/*
 * nobdy logger plugin
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "obd.h"

obd::obd(QString dbname)
{
	tableSchema = "CREATE TABLE obd (load_pct REAL, temp REAL, rpm REAL, vss REAL, iat REAL, maf REAL, throttlepos REAL, time REAL)";

	init(dbname.toStdString(),"obd",tableSchema);
}

void obd::create(double load, double temp, double rpm, double vss, double iat, double maf, double throttlepos, double time)
{
	NameValuePair<double> _load("load_pct",load);
	NameValuePair<double> _temp("temp",temp);
	NameValuePair<double> _rpm("rpm",rpm);
	NameValuePair<double> _vss("vss",vss);
	NameValuePair<double> _iat("iat",iat);
	NameValuePair<double> _maf("maf",maf);
	NameValuePair<double> _throttlepos("throttlepos",throttlepos);
	NameValuePair<double> _time("time",time);

	DictionaryList<double> list;
	list<<_load<<_temp<<_rpm<<_vss<<_iat<<_maf<<_throttlepos<<_time;

	insert<double>(list);
}
