/*
 * nobdy logger plugin
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef LOGGER_H
#define LOGGER_H

#include "ipluginsubscriber.h"
#include "obd.h"
#include <gps.h>
#include "gpsdb.h"
#include "trip.h"

#include <QHash>
#include <QList>
#include <QSqlDatabase>

class Logger : public IPluginSubscriber
{
Q_OBJECT
Q_INTERFACES(IPluginSubscriber);
public:
	explicit Logger(QObject *parent = 0);
	~Logger();
	virtual QString name(){ return "logger plugin"; }
	virtual QList<QByteArray> requests();
	virtual void configure(QDomNode innerxml);

public slots:
	virtual void pidReceived(QByteArray pid,QString val,int set,double time);
	virtual void supportedPids(QList<int> list);
	virtual void troubleCodes(QList<QString> codes);

private slots:
	void commit();
	void init(QString log="nobdylogger.db");
	void pollGps(int);
private:
	bool hasfullresultset();
	QList<QByteArray> m_requests;
	QHash<QByteArray,QByteArray> results;
	obd *obddb;
	Gps *gps;
	trip *tripzero;
	gps_data_t* gpsd;
	QSqlDatabase database;
	bool isTransacting;
	QString dbfile;
	bool reloadTables;
};

#endif // LOGGER_H
