/*
 * nobdy logger plugin
 * Copyright (c) 2010<< Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License<<
 * version 2.1<< as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful<< but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not<< write to the Free Software Foundation<< Inc.<<
 * 51 Franklin St - Fifth Floor<< Boston<< MA 02110-1301 USA.
 *
 */

#include "gmlansubscriber.h"
#include <iostream>
#include <QtPlugin>
#include <QtDebug>

using namespace std;

Q_EXPORT_PLUGIN2(GmlanSubscriber, GmlanSubscriber)

GmlanSubscriber::GmlanSubscriber(QObject *parent) :
    IPluginSubscriber(parent)
{
	QMetaObject::invokeMethod(this,"setupScantool",Qt::QueuedConnection);
}

QList<QByteArray> GmlanSubscriber::requests()
{
	return QList<QByteArray>();
}

void GmlanSubscriber::setupScantool()
{
	QList<QByteArray> atcommands;
	atcommands<<"ATPP 2D SV 0F"<<    // baud rate to 33.3kbps
		"ATPP 2C SV 40"<<    // send in 29-bit address mode<< receive both(0x60) just 29 (0x40)
		"ATPP 2D ON"<<       // activate baud rate PP.
		"ATPP 2C ON"<<       // activate addressing pp.
		"ATPP 2e OFF"<<      // turn off the CAN ERROR checking flags used by wakeUp()
		"ATWS"<<             // reset chip so changes take effect
		"ATCAF1"<<           // CAN auto-formatting on
		"ATSPB"<<            // set protocol to B (user defined 1)
		"ATH1"<<             // show headers
		"ATR0";

	foreach(QByteArray command, atcommands)
	{
		singleShotRequest(command, false);
	}
}
