/*
 * nobdy logger plugin
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "examplesubscriber.h"
#include <iostream>
#include <QtPlugin>
#include <QtDebug>

using namespace std;

Q_EXPORT_PLUGIN2(exampleSubscriber, ExampleSubscriber)

ExampleSubscriber::ExampleSubscriber(QObject *parent) :
    IPluginSubscriber(parent)
{

}

QList<QByteArray> ExampleSubscriber::requests()
{
	return QList<QByteArray>()<<QByteArray("010c")<<QByteArray("010d")<<
			QByteArray("0110")<<QByteArray("0105");
}

void ExampleSubscriber::pidReceived(QByteArray pid,QString val, int set, double time)
{
	Q_UNUSED(set);
	qDebug()<<"pid: "<<pid.data()<<" | val: "<<val<<" | time: "<<time<<endl;
}

void ExampleSubscriber::supportedPids(QList<int> list)
{
	Q_UNUSED(list);
}

void ExampleSubscriber::troubleCodes(QList<QString> codes)
{
	foreach(QString code, codes)
	{
		cout<<"trouble code: "<<code.toStdString()<<endl;
	}
}


