/*
 * dbussimple
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef DBusSimpleSubscriber_H
#define DBusSimpleSubscriber_H

#include "ipluginsubscriber.h"

class DBusSimpleSubscriber : public IPluginSubscriber
{
Q_OBJECT
Q_INTERFACES(IPluginSubscriber);
public:
	explicit DBusSimpleSubscriber(QObject *parent = 0);
	virtual QString name(){ return "example subscriber"; }
	virtual QList<QByteArray> requests();

public slots:
	//from IPluginSubscriber:
	void pidReceived(QByteArray pid, QString val,int set,double time);
	void singleRequestReceived(QByteArray req, QByteArray value);

	//for the adapter:
	void AddRequest(const QByteArray &pid);
	void SingleRequest(const QByteArray &pid);

signals:
	//for the adapter:
	void PidReceived(const QByteArray &pid, const QByteArray &value);
};

#endif // DBusSimpleSubscriber_H
