/*
 * nobdy logger plugin
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "bluetooth.h"
#include "bluetoothsimport.h"
#include <iostream>
#include <QtPlugin>
#include <QtDebug>
#include <QSocketNotifier>

using namespace std;

/// This is the elm prompt
#define ELM_PROMPT ">"

/// Default hide headers
#define ELM_HEADERS 0

/// Default show spaces
#define ELM_SPACES 1

/// Default echo
#define ELM_ECHO 1

/// Default linefeed
#define ELM_LINEFEED 1

/// Protocol version
#define ELM_PROTOCOL_DESCRIPTION "AUTO ISO 15765-4 (CAN 11/250)"

/// Protocol number
#define ELM_PROTOCOL_NUMBER "A8"

/// Default timeout, milliseconds
#define ELM_TIMEOUT 200

/// Adaptive timing [0,1,2]
#define ELM_ADAPTIVETIMING 1

/// ELM "don't know" prompt
#define ELM_QUERY_PROMPT "?"

/// ELM "OK" prompt
#define ELM_OK_PROMPT "OK"

/// ELM "NO DATA" prompt
#define ELM_NODATA_PROMPT "NO DATA"

Q_EXPORT_PLUGIN2(bluetoothSubscriber, Bluetooth)

Bluetooth::Bluetooth(QObject *parent) :
    IPluginSubscriber(parent)
{
	bluetooth = new BluetoothSimPort();

	QSocketNotifier *notifier = new QSocketNotifier(bluetooth->fileDescriptor(), QSocketNotifier::Read, this);

	connect(notifier,SIGNAL(activated(int)),this,SLOT(getLine(int)));
}

QList<QByteArray> Bluetooth::requests()
{
	return QList<QByteArray>();
}

void Bluetooth::pidReceived(QByteArray pid,QString val, int set, double time)
{
	Q_UNUSED(set);
	qDebug()<<"pid: "<<pid.data()<<" | val: "<<val<<" | time: "<<time<<endl;

	bluetooth->writeData(val.toStdString().c_str());
	bluetooth->writeData("\n");
	bluetooth->writeData(ELM_PROMPT);
}

void Bluetooth::supportedPids(QList<int> list)
{
	Q_UNUSED(list);
}

void Bluetooth::troubleCodes(QList<QString> )
{

}

void Bluetooth::getLine(int)
{
	QString line = bluetooth->readLine();

	if(line.contains("ATZ"))
	{
		bluetooth->writeData("ELM327 v1.3a nobdy");
		bluetooth->writeData("\n");
		bluetooth->writeData(ELM_PROMPT);
		return;
	}

	singleShotRequest(line.toAscii());
}
