/**************************************************************************
*   Copyright (C) 2010 by Kevron Rees			                  *
*                                                                         *
*                                                                         *
*   This file is free software: you can redistribute it and/or modify     *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation, either version 3 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   libobd is distributed in the hope that it will be useful,             *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   If not, see <http://www.gnu.org/licenses/>.				  *
***************************************************************************/

/* NOTE, this plugin is GPLV3 because libobd is */

#ifndef GENERICOBD2_H
#define GENERICOBD2_H

#include "ipluginprovider.h"

#include <ObdThread.h>
#include <QDomNode>

class GenericObd2: public IPluginProvider
{
Q_OBJECT
Q_INTERFACES(IPluginProvider)
public:
	GenericObd2(QObject* parent=0);

	///from IPluginProvider
	virtual QString name() { return "GenericOBD2";}
	virtual void setPort(QString port);
	virtual void setBaud(int baud);
	virtual void addRequest(QByteArray request);
	virtual void singleShotRequest(QByteArray request);
	virtual void blindSingleShotRequest(QByteArray request);
	virtual void getSupportedPids();
	virtual void connect();
	virtual void disconnect();
	virtual void requestTroubleCodes();
	virtual void configure(QDomNode innerxml);

public slots:
	void obdPidReceived(QString pid,QString val,int set,double time);

private:
	ObdThread* obd;

};

#endif // GENERICOBD2_H
