/*
 * libnobdy
 * Copyright (c) 2010, Kevron Rees.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef CODES_H
#define CODES_H

#include <QByteArray>

class ObdIICodes
{
public:
	static inline QByteArray Velocity(){ return "010D"; }
	static inline QByteArray EngineRPM(){ return "010C";}
	static inline QByteArray EngineLoad(){ return "0104"; }
	static inline QByteArray FuelPressure(){ return "010A";}
	static inline QByteArray MAFAirFlowRate(){ return "0110";}
	static inline QByteArray IntakeAirTemp() { return "010F"; }
	static inline QByteArray ThrottlePosition() { return "0111"; }
	static inline QByteArray EngineCoolantTemp() { return "0105"; }
};

#endif // CODES_H
