#!/usr/bin/env python
# vim: ts=4 expandtab nowrap

from PyQt4 import QtGui, QtCore
import os,time

DataDir = "/home/user/MyDocs/Games/NFS/"
BinDir = "/home/user/Games/NFS/"
NfsuDir = "/usr/palm/applications/com.ea.app.nfsuc/"
InstDir = "/opt/nfsu-installer/"

DbusServicePath = "/home/user/.local/share/dbus-1/services/"
DesktopEntryPath = "/home/user/.local/share/applications/hildon/"
IconsPath = "/home/user/.local/share/icons/hicolor/scalable/hildon/"
IconSrc = "/usr/share/icons/hicolor/scalable/hildon/nfsu-installer.png"

# Minimal free space (in bytes)
DATA_DIR_MIN_SPACE = 134217728 # 128 Megs
BIN_DIR_MIN_SPACE = 3145728 # 3 Megs

class ClassWizard(QtGui.QWizard):
    def __init__(self, parent=None):
        super(ClassWizard, self).__init__(parent)

        self.addPage(createIntroPage())
        self.addPage(fileChoosePage())
        self.addPage(processPage())
        self.addPage(createConclusionPage())
        self.setWindowTitle("Need For Speed Undercover Installer")

def createIntroPage():
    page = QtGui.QWizardPage()
    page.setTitle("Info")

    label = QtGui.QLabel("This wizard will help you to install "
        "<u><b>Need For Speed Undercover</b></u> game.<br />"
        "It will use Palm Pre emulator.<br />"
        "Please, download .ipk file to the phone and follow the next steps."
    )
    label.setWordWrap(True)
    page.setPixmap(QtGui.QWizard.WatermarkPixmap,
        QtGui.QPixmap(InstDir + 'nfsu-wizard.png'))

    layout = QtGui.QVBoxLayout()
    layout.addWidget(label)
    page.setLayout(layout)

    return page

#
# Choose IPK file
#
class fileChoosePage(QtGui.QWizardPage):
    def __init__(self, parent=None):
        super(fileChoosePage, self).__init__(parent)

        self.setTitle("Choose .ipk file")
        self.setSubTitle("Please, choose .ipk file with game.")

        self.browseButton = QtGui.QPushButton("&Browse...")
        self.browseButton.clicked.connect(self.browseFiles) 

        self.fileLabel = QtGui.QLabel("Path:")
        self.fileLineEdit = QtGui.QLineEdit("")
        self.fileLineEdit.setReadOnly(True)
        self.registerField("path", self.fileLineEdit)

        layout = QtGui.QGridLayout()
        layout.addWidget(self.fileLabel, 0, 0)
        layout.addWidget(self.fileLineEdit, 0, 1)
        layout.addWidget(self.browseButton, 1, 1)
        self.setLayout(layout)

    def browseFiles(self):
        filename = QtGui.QFileDialog.getOpenFileName(self, "Select .IPK Files",
           QtCore.QDir.currentPath(), "IPK Files (*.ipk)")
        self.fileLineEdit.setText(filename)

        self.completeChanged.emit()

    def isComplete(self):
        if self.fileLineEdit.text().isEmpty():
            return False
        return True 

    def validatePage(self):
        path = self.fileLineEdit.text()
        if path.isEmpty():
            return False
        if not QtCore.QFileInfo(path).exists():
            QtGui.QMessageBox.critical(None, "Open error", "File doesn't exist!<br />")
            return False
        self.setField("path", path)
        return True 

class processPage(QtGui.QWizardPage):
    def __init__(self, parent=None):
        super(processPage, self).__init__(parent)

        self.setTitle("Install game")
        self.setSubTitle("Wait until all operations will be finished")

        self.Label = QtGui.QLabel()

        self.layout = QtGui.QGridLayout()
        self.layout.addWidget(self.Label, 0, 0)

        self.steps = QtCore.QStringList()
        self.steps << "<b>Step 1</b>: Sanity check...&nbsp;"
        self.steps << "<b>Step 2</b>: Unpacking .ipk archive...&nbsp;"
        self.steps << "<b>Step 3</b>: Copying files and making symlinks...&nbsp;"
        self.steps << "<b>Step 4</b>: Creating desktop icon...&nbsp;"
        
        self.step1_lbl = QtGui.QLabel("<font color='grey'>"+self.steps[0]+"</color>")
        self.layout.addWidget(self.step1_lbl, 1, 0)
        self.step2_lbl = QtGui.QLabel("<font color='grey'>"+self.steps[1]+"</color>")
        self.layout.addWidget(self.step2_lbl, 2, 0)
        self.step3_lbl = QtGui.QLabel("<font color='grey'>"+self.steps[2]+"</color>")
        self.layout.addWidget(self.step3_lbl, 3, 0)
        self.step4_lbl = QtGui.QLabel("<font color='grey'>"+self.steps[3]+"</color>")
        self.layout.addWidget(self.step4_lbl, 4, 0)

        self.setLayout(self.layout)

    def initializePage(self):
        path = self.field("path")
        self.Label.setText("Processing " + path.toString() + "...");
        self.installGame(path)

    def installGame(self, path):
        progressDialog = QtGui.QProgressDialog()
        progressDialog.setRange(0, 6)
        progressDialog.setWindowTitle("Installing NFSU")
        progressDialog.show()
        QtGui.qApp.processEvents()
        if progressDialog.wasCanceled():
            return False;

        self.errorMsg = ""

        # Step 1
        progressDialog.setValue(1)
        progressDialog.setLabelText(self.steps[0])
        progressDialog.forceShow()
        if self.inst_sanityCheck(path):
            status = "<font color='green'><b>OK</b/</font>"
            self.step1_lbl.setText(self.steps[0] + status)
        else:
            status = "<font color='red'><b>FAILED</b/</font>"
            status += "<br /><font color='red'>" + self.errorMsg + "</font>"
            self.step1_lbl.setText(self.steps[0] + status)
            return False

        # Step 2
        progressDialog.setLabelText(self.steps[1] + " (it may take a while)")
        progressDialog.setValue(2)
        progressDialog.forceShow()

        if self.inst_unpackIpk(path):
            status = "<font color='green'><b>OK</b/</font>"
            self.step2_lbl.setText(self.steps[1] + status)
        else:
            status = "<font color='red'><b>FAILED</b/</font>"
            status += "<br /><font color='red'>" + self.errorMsg + "</font>"
            self.step2_lbl.setText(self.steps[1] + status)
            return False

        # Step 3
        progressDialog.setValue(4)
        progressDialog.setLabelText(self.steps[2])
        progressDialog.forceShow()
        if self.inst_copyFiles():
            status = "<font color='green'><b>OK</b/</font>"
            self.step3_lbl.setText(self.steps[2] + status)
        else:
            status = "<font color='red'><b>FAILED</b/</font>"
            status += "<br /><font color='red'>" + self.errorMsg + "</font>"
            self.step3_lbl.setText(self.steps[2] + status)
            return False


        # Step 4
        progressDialog.setValue(5)
        progressDialog.setLabelText(self.steps[3])
        progressDialog.forceShow()
        if self.inst_createLauncher():
            status = "<font color='green'><b>OK</b/</font>"
            self.step4_lbl.setText(self.steps[3] + status)
        else:
            status = "<font color='red'><b>FAILED</b/</font>"
            status += "<br /><font color='red'>" + self.errorMsg + "</font>"
            self.step4_lbl.setText(self.steps[3] + status)
            return False

        progressDialog.setValue(6)

        progressDialog.close()

    def inst_sanityCheck(self,path):
        self.errorMsg = ""
        # Check file existence
        if not QtCore.QFileInfo(path.toString()).exists():
            self.errorMsg = "IPK file '" + path.toString() + "' cannot be opened!"
            return False
        # Check ar/tar-gnu availability
        if not QtCore.QFileInfo("/usr/bin/ar").exists() or not QtCore.QFileInfo("/usr/bin/gnu/tar").exists():
            self.errorMsg = "Ar and/or tar-gnu binaries not found!<br />"
            self.errorMsg += "Did you install <b>binutils</b> and <b>tar-gnu</b> packages?"
            return False
        # Check whether directories already exists
        if QtCore.QDir(BinDir).exists():
            self.errorMsg = "Directory " +  BinDir + " already exists!<br />"
            self.errorMsg += "Uninstall previous installation before!"
            return False
        if QtCore.QDir(DataDir).exists():
            self.errorMsg = "Directory " +  DataDir + " already exists!<br />"
            self.errorMsg += "Uninstall previous installation before!"
            return False
        # Create dirs
        if not QtCore.QDir().mkpath(BinDir):
            self.errorMsg = "Cannot create bin directory " + BinDir
            self.errorMsg += "<br />Check path and permissions"
            return False
        if not QtCore.QDir().mkpath(DataDir):
            self.errorMsg = "Cannot create data directory " + DataDir
            self.errorMsg += "<br />Check path and permissions"
            return False
        # Check free space 
        stat = os.statvfs(DataDir)
        freeSpaceData = stat.f_bsize * stat.f_bavail
        stat = os.statvfs(BinDir)
        freeSpaceBin = stat.f_bsize * stat.f_bavail
        if freeSpaceBin < BIN_DIR_MIN_SPACE:
            self.errorMsg = "Not enough space at " + BinDir + "!<br />"
            self.errorMsg += "Need at least " + str(BIN_DIR_MIN_SPACE/1024/1024) + "Mb, "
            self.errorMsg += "but have only " + str(freeSpaceBin/1024/1024) + "Mb."
            return False
        if freeSpaceData < DATA_DIR_MIN_SPACE:
            self.errorMsg = "Not enough space at " + DataDir + "!<br />"
            self.errorMsg += "Need at least " + str(DATA_DIR_MIN_SPACE/1024/1024) + "Mb, "
            self.errorMsg += "but have only " + str(freeSpaceData/1024/1024) + "Mb."
            return False
        return True

    def inst_unpackIpk(self, path):
        self.errorMsg = ""

        process1 = QtCore.QProcess()
        process2 = QtCore.QProcess()
        process1.setStandardOutputProcess(process2)
        process1.start("/usr/bin/ar p " + path.toString() + " data.tar.gz")
        process2.start("/usr/bin/gnu/tar xz -C " + DataDir)
        process1.waitForFinished(120000) # Timeout is 2 minutes
        process2.waitForFinished(120000) # Timeout is 2 minutes
        if not process2.exitCode() == 0:
            self.errorMsg = "Cannot unpack. Return code: " + str(process2.exitCode())
            print str(process1.readAllStandardError())
            print str(process2.readAllStandardError())
            return False
        return True

    def inst_copyFiles(self):
        self.errorMsg = ""
        # Check files first
        nfs_bin = QtCore.QFile(DataDir + NfsuDir + "nfsuc")
        if not nfs_bin.exists():
            self.errorMsg = "nfsuc binary not found! Path is:<br />"
            self.errorMsg += nfs_bin.fileName()
            return False
        nfs_res = QtCore.QFile(DataDir + NfsuDir + "res_nfsuc")
        if not nfs_res.exists():
            self.errorMsg = "res_nfsuc dir not found! Path is:<br />"
            self.errorMsg += nfs_res.fileName()
            return False
        # Copy binary
        if not nfs_bin.copy(BinDir + "/nfsuc"):
            self.errorMsg = "Cannot copy nfsuc binary!"
            return False
        # Chmod +x binary
        nfs_local_bin = QtCore.QFile(BinDir + "nfsuc")
        if not nfs_local_bin.setPermissions(nfs_local_bin.permissions() | QtCore.QFile.ExeOwner | QtCore.QFile.ExeGroup):
            self.errorMsg = "Cannot change permissions on nfsuc binary!"
            return False
        # Create symlink to resources dir
        if not nfs_res.link(BinDir + "/res_nfsuc"):
            self.errorMsg = "Cannot create symlink to res_nfsuc"
            return False
        return True

    def inst_createLauncher(self):
        self.errorMsg = ""

        # Prepare dir
        if not QtCore.QDir().mkpath(DesktopEntryPath):
            self.errorMsg = "Cannot create path for Desktop file: " + DesktopEntryPath
            return False
        if not QtCore.QDir().mkpath(DbusServicePath):
            self.errorMsg = "Cannot create path for DBus Service file: " + DbusServicePath
            return False
        if not QtCore.QDir().mkpath(IconsPath):
            self.errorMsg = "Cannot create path for Icon file: " + IconsPath 
            return False

        # Desktop file
        desktop_entry  = "[Desktop Entry]\n"
        desktop_entry += "Encoding=UTF-8\n"
        desktop_entry += "Version=1.0\n"
        desktop_entry += "Type=Application\n"
        desktop_entry += "Name=Need For Speed Undercover\n"
        desktop_entry += "Exec=\"/opt/preenv/wrapper.sh\" \"com.ea.app.nfsuc\" \"" + BinDir + "nfsuc\"\n"
        desktop_entry += "X-Osso-Type=application/x-executable\n"
        desktop_entry += "X-Osso-Service=com.ea.app.nfsuc\n"
        desktop_entry += "X-Preenv-Generated=true\n"
        desktop_entry += "X-Preenv-Vendor=Electronic Arts\n"
        desktop_entry += "X-Maemo-Category=Games\n"
        desktop_entry += "Icon=nfsu-palm\n"
        desktop_file = QtCore.QFile(DesktopEntryPath + "/nfsu-palm.desktop")
        if not desktop_file.open(QtCore.QFile.WriteOnly | QtCore.QFile.Text):
            self.errorMsg = "Cannot create Desktop file"
            return False
        desktop_file.writeData(desktop_entry)
        desktop_file.close()
        
        # DBUS Service file    
        dbus_str = "[D-BUS Service]\n"
        dbus_str += "Name=com.ea.app.nfsuc\n"
        dbus_str += "Exec=\"/opt/preenv/wrapper.sh\" \"com.ea.app.nfsuc\" \"" + BinDir + "nfsuc\""
        dbus_file = QtCore.QFile(DbusServicePath + "nfsu-palm.service")
        if not dbus_file.open(QtCore.QFile.WriteOnly | QtCore.QFile.Text):
            self.errorMsg = "Cannot create DBus-Service file"
            return False
        dbus_file.writeData(dbus_str)
        dbus_file.close()

        # Icon file
        if not QtCore.QFile().copy(IconSrc, IconsPath + "nfsu-palm.png"):
            self.errorMsg = "Cannot copy icon to " + IconsPath
            return False

        return True


def createConclusionPage():
    page = QtGui.QWizardPage()
    page.setTitle("Finished")

    label = QtGui.QLabel("The game successfully installed. You can find an icon in the applications screen now.<br />Have a fun!")
    label.setWordWrap(True)

    layout = QtGui.QVBoxLayout()
    layout.addWidget(label)
    page.setLayout(layout)

    return page


if __name__ == '__main__':

    import sys

    app = QtGui.QApplication(sys.argv)

    wizard = ClassWizard()
    wizard.show()

    sys.exit(wizard.exec_())
