#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "nalarmsettings.h"

#include <QColorDialog>
#include <QColor>
#include <QMessageBox>
#include <QFontDatabase>

#define STR_VERSION "0.2.9"
#define STR_CRLF "<br>"
#define STR_QT_VERSION "<b>Qt 4.6.2</b>"
#define STR_COPYRIGHT "Copyright (c) 2010 Avis"
#define STR_EMAIL "<a href=\"mailto:avis@allnokia.ru\">avis@allnokia.ru</a>"
#define STR_DONATE "<a href=https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=TBV3R4AU2PVHS>Donate</a>"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    //ui->labelColor->setAutoFillBackground(true);
    buildFontList();
    loadSettings();
    fontChanged(0);
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::buildFontList()
{
    QFontDatabase database;

    foreach (QString family, database.families()) {
        ui->cbFont->addItem(family);
        }
}

void SettingsDialog::btnColorClicked()
{
    QColor newColor = QColorDialog::getColor(ui->labelColor->palette().color(QPalette::WindowText), 0);
    if (newColor.isValid())
        {
            QPalette qp = ui->labelColor->palette();
            qp.setColor(QPalette::WindowText,newColor);
            ui->labelColor->setPalette(qp);
        }
}

void SettingsDialog::dumpSettings() const
{
    nalarmsettings::getInstance().setColor(ui->labelColor->palette().color(QPalette::WindowText));
    nalarmsettings::getInstance().setSize(ui->spinSize->value());
    nalarmsettings::getInstance().setWidth(ui->spinWidth->value());
    QFont fnt;
    fnt.setFamily(ui->cbFont->currentText());
    fnt.setBold(ui->chbBold->isChecked());
    fnt.setItalic(ui->chbItalic->isChecked());
    fnt.setPointSize(ui->spinFontSize->value());
    nalarmsettings::getInstance().setFont(fnt);
    nalarmsettings::getInstance().setShowHeader(ui->cbShowHeader->isChecked());
    nalarmsettings::getInstance().setShowRemain(ui->chbRemain->isChecked());
    nalarmsettings::getInstance().setShowTitle(ui->chbTitle->isChecked());

    nalarmsettings::getInstance().setShowRecurrent(ui->chbRecurrent->isChecked());
    nalarmsettings::getInstance().setShowEmpty(ui->chbEmptyVisible->isChecked());
    nalarmsettings::getInstance().setAlarmFilter(ui->cbFilter->currentIndex());
    nalarmsettings::getInstance().setTimeFrame(ui->spinTimeFrame->value());

    nalarmsettings::getInstance().setTransparency(ui->slideTransparency->value());
//    nalarmsettings::getInstance().setAlwaysShowDate(ui->cbShowDate->isChecked()); // not used
}

void SettingsDialog::loadSettings()
{
    QColor dColor = nalarmsettings::getInstance().getColor();
    QPalette qp = ui->labelColor->palette();
    qp.setColor(QPalette::WindowText,dColor);
    ui->labelColor->setPalette(qp);
    int wSize = nalarmsettings::getInstance().getSize();
    ui->cbShowHeader->setChecked(nalarmsettings::getInstance().isShowHeader());
    ui->chbRemain->setChecked(nalarmsettings::getInstance().isShowRemain());
    ui->chbTitle->setChecked(nalarmsettings::getInstance().isShowTitle());

    ui->chbRecurrent->setChecked(nalarmsettings::getInstance().isShowRecurrent());
    ui->chbEmptyVisible->setChecked(nalarmsettings::getInstance().isShowEmpty());
    ui->cbFilter->setCurrentIndex(nalarmsettings::getInstance().alarmFilter());
    ui->spinTimeFrame->setValue(nalarmsettings::getInstance().timeFrame());

    ui->slideTransparency->setValue(nalarmsettings::getInstance().getTransparency());
//    ui->cbShowDate->setChecked(nalarmsettings::getInstance().isAlwaysShowDate()); // not used

    ui->spinSize->setValue(wSize);
    ui->spinWidth->setValue(nalarmsettings::getInstance().getWidth());
    {
        bool found = false;
        QFont fnt(nalarmsettings::getInstance().getFont());
        QString fnt_family(fnt.family());
        for (int i = 0; i < ui->cbFont->count(); i++)
        {
        if (ui->cbFont->itemText(i) == fnt_family)
            {
            ui->cbFont->setCurrentIndex(i);
            found = true;
            break;
        }
        }
        if (found)
        {
            ui->chbBold->setChecked(fnt.bold());
            ui->chbItalic->setChecked(fnt.italic());
            ui->spinFontSize->setValue(fnt.pointSize());
        }
        else
            ui->cbFont->setCurrentIndex(0);
    }
}

void SettingsDialog::showAbout()
{
    QString msgName = tr("Next Alarm");
    QString msgDeveloped = tr("Developed with");
    QString msgDescr = tr("Desktop widget, showing time of next alarms");
    QString msgReports = tr("Send reports to:");
    QString msgText = "<b>" + msgName + "</b> " + STR_VERSION + STR_CRLF;
    msgText += msgDescr + STR_CRLF;
    msgText += msgDeveloped + " " + STR_QT_VERSION + STR_CRLF + STR_CRLF;
    msgText += msgReports + " " + STR_EMAIL + STR_CRLF;
    msgText += QString(STR_DONATE) + STR_CRLF + STR_CRLF;
    msgText += STR_COPYRIGHT;
    QMessageBox::about(this, tr("About Next Alarm"),msgText);
}

void SettingsDialog::showQtAbout()
{
    QMessageBox::aboutQt(this);
}

void SettingsDialog::fontChanged(int aIndex)
{
    Q_UNUSED(aIndex);
    QString qs = ui->cbFont->currentText();
    QFont qf (qs);
    qf.setBold(ui->chbBold->isChecked());
    qf.setItalic(ui->chbItalic->isChecked());
    qf.setPointSize(ui->spinFontSize->value());
    ui->labelColor->setFont(qf);
}
