#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "nalarmsettings.h"

#include <QColorDialog>
#include <QColor>
#include <QMessageBox>
#include <QFontDatabase>

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    //ui->labelColor->setAutoFillBackground(true);
    buildFontList();
    loadSettings();
    fontChanged(0);
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::buildFontList()
{
    QFontDatabase database;

    foreach (QString family, database.families()) {
        ui->cbFont->addItem(family);
        }
}

void SettingsDialog::btnColorClicked()
{
    QColor newColor = QColorDialog::getColor(ui->labelColor->palette().color(QPalette::WindowText), 0);
    if (newColor.isValid())
        {
            QPalette qp = ui->labelColor->palette();
            qp.setColor(QPalette::WindowText,newColor);
            ui->labelColor->setPalette(qp);
        }
}

void SettingsDialog::dumpSettings() const
{
    nalarmsettings::getInstance().setColor(ui->labelColor->palette().color(QPalette::WindowText));
    nalarmsettings::getInstance().setSize(ui->spinSize->value());
    nalarmsettings::getInstance().setWidth(ui->spinWidth->value());
    QFont fnt;
    fnt.setFamily(ui->cbFont->currentText());
    fnt.setBold(ui->chbBold->isChecked());
    fnt.setItalic(ui->chbItalic->isChecked());
    fnt.setPointSize(ui->spinFontSize->value());
    nalarmsettings::getInstance().setFont(fnt);
    nalarmsettings::getInstance().setShowHeader(ui->cbShowHeader->isChecked());
    nalarmsettings::getInstance().setShowRemain(ui->chbRemain->isChecked());
    nalarmsettings::getInstance().setShowTitle(ui->chbTitle->isChecked());
    nalarmsettings::getInstance().setStdOnly(ui->chbStdOnly->isChecked());
}

void SettingsDialog::loadSettings()
{
    QColor dColor = nalarmsettings::getInstance().getColor();
    QPalette qp = ui->labelColor->palette();
    qp.setColor(QPalette::WindowText,dColor);
    ui->labelColor->setPalette(qp);
    int wSize = nalarmsettings::getInstance().getSize();
    ui->cbShowHeader->setChecked(nalarmsettings::getInstance().isShowHeader());
    ui->chbRemain->setChecked(nalarmsettings::getInstance().isShowRemain());
    ui->chbTitle->setChecked(nalarmsettings::getInstance().isShowTitle());
    ui->chbStdOnly->setChecked(nalarmsettings::getInstance().isStdOnly());
    ui->spinSize->setValue(wSize);
    ui->spinWidth->setValue(nalarmsettings::getInstance().getWidth());
    {
        bool found = false;
        QFont fnt(nalarmsettings::getInstance().getFont());
        QString fnt_family(fnt.family());
        for (int i = 0; i < ui->cbFont->count(); i++)
        {
        if (ui->cbFont->itemText(i) == fnt_family)
            {
            ui->cbFont->setCurrentIndex(i);
            found = true;
            break;
        }
        }
        if (found)
        {
            ui->chbBold->setChecked(fnt.bold());
            ui->chbItalic->setChecked(fnt.italic());
            ui->spinFontSize->setValue(fnt.pointSize());
        }
        else
            ui->cbFont->setCurrentIndex(0);
    }
}

void SettingsDialog::showAbout()
{
    QMessageBox::about(this, tr("About Next Alarm"),
                        tr("<b>Next Alarm</b> 0.1.5<br>"
                        "Using <b>Qt 4.6.2</b><br>"
                        "Copyright (c) 2010 Avis<br>"
                        "<a href=\"mailto:avis@allnokia.ru\">avis@allnokia.ru</a><br><br>"
                        "Desktop widget, showing time of next alarm"));
}

void SettingsDialog::showQtAbout()
{
    QMessageBox::aboutQt(this);
}

void SettingsDialog::fontChanged(int aIndex)
{
    QString qs = ui->cbFont->currentText();
    QFont qf (qs);
    qf.setBold(ui->chbBold->isChecked());
    qf.setItalic(ui->chbItalic->isChecked());
    qf.setPointSize(ui->spinFontSize->value());
    ui->labelColor->setFont(qf);
}
