#include "nalarmsettings.h"
#include <QSettings>
#include <QVariant>

/*It's better to use QCoreApplication::setOrganizationName(), QCoreApplication::setOrganizationDomain(),
and QCoreApplication::setApplicationName(). And then only use QSettings() in any place.
But this solution is based on incapsulation strategy, and therefore if this code become a part of lib
and will be used in app without setted appropriate values for application and organization names, then it would probably
 cause some problems */

static const QString organizationName = QString("Avis");
static const QString applicationName = QString("NextAlarm");


//get widget size;
int nalarmsettings::getSize() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    return sett.value("WidgetLines",3).toInt();
}

//set widget size;
void nalarmsettings::setSize(const int &aSize) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("WidgetLines",aSize);
}

//get widget width;
int nalarmsettings::getWidth() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    return sett.value("WidgetWidth",300).toInt();
}

//set widget width;
void nalarmsettings::setWidth(const int &aSize) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("WidgetWidth",aSize);
}

//get color of digits
QColor nalarmsettings::getColor() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    int r = sett.value("DigitsColorR",255).toInt();
    int g = sett.value("DigitsColorG",255).toInt();
    int b = sett.value("DigitsColorB",255).toInt();
    int a = sett.value("DigitsColorA",255).toInt();
    return QColor(r,g,b,a);
}

//set color of digits
void nalarmsettings::setColor(const QColor &aColor) const
{
    QSettings sett(organizationName,applicationName);
    int r = aColor.red();
    int g = aColor.green();
    int b = aColor.blue();
    int a = aColor.alpha();
    sett.setValue("DigitsColorR",r);
    sett.setValue("DigitsColorG",g);
    sett.setValue("DigitsColorB",b);
    sett.setValue("DigitsColorA",a);
}

//get font
QFont nalarmsettings::getFont() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    QFont fnt;
    fnt.setFamily(sett.value("FontFamily",QString("Helvetica")).toString());
    fnt.setBold(sett.value("FontBold",false).toBool());
    fnt.setItalic(sett.value("FontItalic",false).toBool());
    fnt.setPointSize(sett.value("FontSize",16).toInt());
    return fnt;
}

//set font
void nalarmsettings::setFont(const QFont &aFont) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("FontFamily",aFont.family());
    sett.setValue("FontBold",aFont.bold());
    sett.setValue("FontItalic",aFont.italic());
    sett.setValue("FontSize",aFont.pointSize());
}

//get show header
bool nalarmsettings::showHeader() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    return sett.value("ShowHeader",true).toBool();
}

//set show header
void nalarmsettings::setShowHeader(const bool &aShow) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("ShowHeader",aShow);
}
