#ifndef ALARMWINDOW_H
#define ALARMWINDOW_H

#include <QWidget>

namespace Ui {
    class AlarmWindow;
}

class AlarmWindow : public QWidget
{
    Q_OBJECT

public:
    explicit AlarmWindow(QWidget *parent = 0);
    ~AlarmWindow();

public slots:
    void showSettingsDialog();
    void homeScreenChanged(bool isOnCurrentHomescreen);
    void listClicked();

protected:
    void mouseReleaseEvent ( QMouseEvent * e );

private:
    void loadSettings();
    void showClock();
    void fillAlarmList();
    void updateUi();

private:
    Ui::AlarmWindow *ui;
    int m_numberAlarms;
    int m_width;
    QFont m_font;
    QColor m_color;
    bool m_showCaption;
};

#endif // ALARMWINDOW_H
