/*
 * Copyright (C) 2003 Robert Kooima
 *
 * NEVERBALL is  free software; you can redistribute  it and/or modify
 * it under the  terms of the GNU General  Public License as published
 * by the Free  Software Foundation; either version 2  of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT  ANY  WARRANTY;  without   even  the  implied  warranty  of
 * MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU
 * General Public License for more details.
 */

#define _ISOC99_SOURCE
#include <math.h>
#include <stdio.h>

#define M_PI       3.14159265358979323846
#define ACCEL_FILENAME "/sys/class/i2c-adapter/i2c-3/3-001d/coord"

static struct _accel {
    float x;
    float y;
    float z;
} accel;

void tilt_init(void)
{
}

void tilt_free(void)
{
}

int tilt_stat(void)
{
    FILE *fd;
    int i, ax, ay, az;
    static int has_read = 0;

    fd = fopen(ACCEL_FILENAME, "r");
    if (!fd) return 0;

    i = fscanf(fd, "%i %i %i", &ax, &ay, &az);
    fclose(fd);

    if (i != 3) return 0;

    /* Combine with previous reading */
    if (has_read)
    {
        accel.x = ax * 0.2f + accel.x * 0.8f;
        accel.y = ay * 0.2f + accel.y * 0.8f;
        accel.z = az * 0.2f + accel.z * 0.8f;
    }
    else
    {
        accel.x = ax;
        accel.y = ay;
        accel.z = az;
        has_read = 1;
    }

    return i == 3 ? 1 : 0;
}

int  tilt_get_button(int *b, int *s)
{
    return 0;
}

float tilt_get_x(void)
{
    return atan2f(accel.y, -accel.z) * 180.0f / M_PI;
}

float tilt_get_z(void)
{
    return atan2f(-accel.x, -accel.z) * 180.0f / M_PI;
}

