#!/usr/bin/env python

# This file is part of NetStory.
# Author: Jere Malinen <jeremmalinen@gmail.com>
  

from datetime import datetime
import os
import time

import gconf

import settings


SLEEP_TIME = 3600
# prevents from writing e.g. 22:49:59 and 23:00:00 
# (case when time has changed during sleep)
NEXT_SLEEP_ATLEAST = 1800  
# prevents from writing first line e.g. 22:59:30 and next would be 23:00:00
# (case starting daemon hh:59:00-hh:59:59)
FIRST_SLEEP_ATLEAST = 60   


def log_loop():
    try:
        f = open(settings.DATA, 'a')
        print 'Writing to: ' + settings.DATA
        first = True
        while 1:
            next_sleep = SLEEP_TIME - time.time() % SLEEP_TIME
            if next_sleep > NEXT_SLEEP_ATLEAST or \
               (first and next_sleep > FIRST_SLEEP_ATLEAST):
                download, upload = read_counters()
                write_data(f, download, upload)
                first = False
            time.sleep(next_sleep) #sleep until next interval
    except KeyboardInterrupt:
        print 'Stopped'

def read_counters():
    client = gconf.client_get_default()
    download = client.get_string(settings.GPRS_HOME_DOWNLOAD)
    upload = client.get_string(settings.GPRS_HOME_UPLOAD)
    return (download, upload)
    
def write_data(f, download, upload):
    if check(download) and check(upload):
        f.write('%s,%s,%s\n' % 
                (datetime.now().strftime(settings.DATA_TIME_FORMAT), 
                download, upload))
        f.flush()
        os.fsync(f.fileno())
        
def check(value='1'):
    try:
        int(value)
        return True
    except TypeError, e:
        print e
    except ValueError, e:
        print e
    return False

if __name__ == "__main__":
    if not os.path.exists(settings.DIR):
        os.mkdir(settings.DIR)
    log_loop()
