import QtQuick 2.0
import Sailfish.Silica 1.0

import "../components"
import "../delegates"
import "../js/api.js" as Api

PageWrapper {
    id: root
    signal update()
    signal loadHistory()
    signal badge(variant obj)
    signal user(string userid)
    signal checkin(variant content)
    signal venue(string venueid)
    signal tip(string tipid)

    signal shout()
    signal nearby()
    signal recent()

    property bool nearbyPressed: false

    property string lastUpdateTime: "0"
    property string leadingMarker: ""
    property string trailingMarker: ""
    property bool moreData: false
    property bool isUpdating: false

    property int loaded: 0

    property int batchSize: 20

    property alias friendsCheckinsModel: friendsCheckinsModel
    property alias timerFeedUpdate: timerFeedUpdate

    headerText: qsTr("Friends feed")
    headerIcon: "image://theme/icon-m-location"

    onHeaderClicked: {
        loadedContent.scrollToTop();
    }
    onHeaderButtonClicked: {
        pageStack.push(Qt.resolvedUrl("VenuesList.qml"))
    }

    function show_error(msg) {
        isUpdating = false;
        show_error_base(msg);
    }

    function reset() {
        moreData = false;
        isUpdating = false;
        loaded = 0;
        friendsCheckinsModel.clear();

        lastUpdateTime = "0";
        leadingMarker = "";
        trailingMarker = "";
    }

    function addItem(item) {
        friendsCheckinsModel.insert(loaded,{"item":item});
        loaded += 1;

        //TODO: no homefeed integration so far
        /*if (appConfig.feedUpdateInterval !== "0"
                && appConfig.integrationHomeFeed !=="0") {

            item.content.photoCached = "";
            item.content.venuePhotoCached = "";

            var feeditem = item.content.id + "-feed";
            var feeditemobj = Api.objs.save(feeditem);

            var feedphoto = item.content.id + "-photo";
            var feedphotoobj = Api.objs.save(feedphoto);

            feeditemobj.cacheCallback = function(status, url) {
                if (!status) return;
                item.content.photoCached = url;
                platformUtils.addFeedItem(item);
            }


            feedphotoobj.cacheCallback = function(status,url) {
                item.content.venuePhotoCached = url;
                cache.queueObject(item.content.photo, feeditem);
            }

            if (item.content.venuePhoto !== "") {
                cache.queueObject(item.content.venuePhoto, feedphoto);
            } else {
                feedphotoobj.cacheCallback(true, "");
                Api.objs.remove(feedphoto);
            }
        }*/
    }

    function updateItem(position, update) {
        //TODO: update
        friendsCheckinsModel.set(position, {"content": update.content});
        if (configuration.feedIntegration !=="0") {
            platformUtils.updateFeedItem({
                            "type":update.type,
                            "content": update.content
                        });
        }
    }

    function deleteItem(itemid) {
        //TODO: delete
        for (var i=0;i<friendsCheckinsModel.count;i++) {
            var item = friendsCheckinsModel.get(i);
            if (item.content.id === itemid) {
                removeItem(i);
                return;
            }
        }
    }

    function removeItem(position) {
        if (configuration.feedIntegration !=="0") {
            var item = friendsCheckinsModel.get(position);
            platformUtils.removeFeedItem({
                             "type":item.type,
                             "content": item.content
                         });
        }
        friendsCheckinsModel.remove(position);
    }

    function load() {
        var page = root;

        page.update.connect(function(lastupdate) {
            if (appConfig.feedUpdateInterval === 0) {
                page.reset();
            }
            loaded = 0;
            Api.feed.loadFriendsFeed(page)
        });
        page.loadHistory.connect(function(){
            console.log("FEED: loading history");
            loaded = friendsCheckinsModel.count;
            Api.feed.loadFriendsFeed(page,true);
        });
        page.recent.connect(function() {
            page.reset();
            Api.feed.loadFriendsFeed(page);
        });
        page.nearby.connect(function() {
            page.reset();
            Api.feed.loadFriendsFeed(page);
        });
        page.checkin.connect(function(content) {
            stack.push(Qt.resolvedUrl("Checkin.qml"),{"checkinID":content.id, "checkinCache": content});
        });
        page.user.connect(function(id){
            stack.push(Qt.resolvedUrl("User.qml"),{"userID":id});
        });
        page.venue.connect(function(id) {
            stack.push(Qt.resolvedUrl("Venue.qml"), {"venueID":id});
        });
        page.tip.connect(function(id) {
            stack.push(Qt.resolvedUrl("TipPage.qml"), {"tipID":id});
        });
        page.badge.connect(function(obj) {
            stack.push(Qt.resolvedUrl("BadgeInfo.qml"), Api.makeBadgeObject(obj));
        });
        timerFeedUpdate.restart(); //Start autoupdate
        update();
    }

    Timer {
        id: timerFeedUpdate
        interval: appConfig.feedUpdateInterval * 1000
        repeat: true
        onTriggered: {
            root.update()
        }
    }

    ListModel {
        id: friendsCheckinsModel
    }

    tools: Component {
        PullDownMenu {
            MenuItem {
                text: "My profile"
                onClicked: pageStack.push(Qt.resolvedUrl("User.qml"), {"userID":"self"})
            }
            MenuItem {
                text: "Checkin"
                onClicked: pageStack.push(Qt.resolvedUrl("VenuesList.qml"))
            }
            MenuItem {
                text: "Refresh"
                onClicked: root.update()
            }
        }
    }

    content: SilicaListView {
        id: friendsCheckinsView
        model: friendsCheckinsModel
        delegate: friendsFeedDelegate

        clip: true
        cacheBuffer: 2000
        spacing: 10
        pressDelay: 0

        footer: Column {
            width: parent.width

            Item {
                width: parent.width
                height: myTheme.paddingLarge*3
            }
        }
        PushUpMenu {
            MenuItem {
                text: "Load more"
                onClicked: {
                    moreData = false;
                    loadHistory();
                }
            }
        }
        ScrollDecorator{ flickable: loadedContent }
    }

    Component {
        id: friendsFeedDelegate

        Loader {
            width: loadedContent.width
            //asynchronous: true
            function getComponentByType(type) {
                var objtype = content.content.type;
                if (type === "create") {
                    if (objtype === "checkin") {
                        return feedDelegateCheckin
                    }
                    /*else if (objtype === "friend")
                        return friendsFeedDelegateFriend
                    else if (objtype === "tip")
                       return friendsFeedDelegateTip
                    else if (objtype === "pageupdate")
                        return friendsFeedDelegatePage
                    else if (objtype === "savetip")
                        return friendsFeedDelegateTip
                    else if (objtype === "savelist")
                        return friendsFeedDelegateSaveList
                    else if (objtype === "savevenue")
                        return friendsFeedDelegateVenue
                    else if (objtype === "installplugin")
                        return friendsFeedDelegateInstallPlugin
                    else if (objtype === "likevenue")
                        return friendsFeedDelegateVenue
                    else if (objtype === "likepage")
                        return friendsFeedDelegatePage
                    else if (objtype === "likepageupdate") //this is disabled now
                        return friendsFeedDelegatePage
                    else if (objtype === "awardbadge")
                        return friendsFeedDelegateAward*/
                    else if (objtype === "aggregation") {
                        return feedDelegateAggregation;
                    }/*
                } else if (type === "like") {
                    if (content.type === "tip2") {
                        return feedDelegateTip;
                    }*/
                } else if (type === "friend") {
                    if (objtype === 'user') {
                        return feedDelegateFriendUser;
                    }
                }
                console.log("DELEGATE TYPE ACTION:", type, "TYPE", objtype);
                return feedDelegateUnknown;
            }

            property variant content: model.item
            sourceComponent: getComponentByType(model.item.type)
        }
    }

    Component {
        id: feedDelegateCheckin

        DelegateCheckin {
            object: content.content.object

            onAreaClicked: {
                root.checkin(object);
            }

            onAreaPressAndHold: {
                appWindow.sendDebugInfo(
                    {
                        "debugType": "DebugWidget",
                        "debugContent": content
                    }
                );
            }
        }
    }

    Component {
        id: feedDelegateFriendUser

        DelegateFriendUser {
            object: content
        }
    }

    Component {
        id: feedDelegateTip

        DelegateTip {
            object: content.content.object
        }
    }

    Component {
        id: feedDelegateAggregation

        DelegateAggregation {
            object: content

            onAreaPressAndHold: {
                appWindow.sendDebugInfo(
                    {
                        "debugType": "DebugWidget",
                        "debugContent": content
                    }
                );
            }
        }
    }

    Component {
        id: feedDelegateUnknown

        DebugWidget {
            debugType: content.type ? content.type : "unknown"
            debugContent: content
        }
    }

}
