import QtQuick 2.0
import Sailfish.Silica 1.0
import QtPositioning 5.0

import "components"
import "pages"
import "js/api.js" as Api

ApplicationWindow {
    id: appWindow
    property bool windowActive: Qt.application.active

    onWindowActiveChanged: {
        console.log("active: " + windowActive);

        if (appConfig.gpsAllow !== "1") {
            positionSource.active = false;
            return;
        }
        if (!windowActive) {
            if (positionSource.position.latitudeValid) {
                timerGPSUnlock.start();
            } else {
                positionSource.active = windowActive;
            }
        } else {
            timerGPSUnlock.stop();
            positionSource.active = windowActive;
        }
    }    

    Component.onCompleted: {
        Api.setPositionSource(positionSource);
    }

    initialPage: appConfig.foursquareAccessToken.length > 0 ? friendsFeedPage : welcomePage

    Component {
        id: friendsFeedPage
        FriendsFeed {}
//        Badges {
//            userID: "self"
//        }
//        User {
//            userID: "self"
//        }
    }

    Component {
        id: welcomePage
        Welcome {
            newuser: true
        }
    }

    /*Page {
        id: mainPage
        //tools: commonTools
        tools: stack.currentPage !== null ? stack.currentPage.tools : null
        onToolsChanged: {
            if (pageStack) {
                pageStack.toolBar.tools = tools;
            }
        }

        TabGroup {
            id: tabgroup
            currentTab: tabLogin
            anchors.fill: parent

            property variant lastTab

            onCurrentTabChanged: {
                if (currentTab.depth === 0) {
                    currentTab.load();
                }
            }
        }

        NotificationDialog {
            id: notificationDialog
            z: 20
            width: parent.width
            state: "hidden"
            onClose: {
                notificationDialog.state = "hidden";
            }
        }
    }*/

    /*Component{
        id: dummyMenu

        Menu {
            MenuLayout {
                MenuItem {
                    text: qsTr("Check updates")
                    onClicked: {
                        appConfig.getupdates();
                    }
                }
                MenuItem {
                    text: qsTr("Settings")
                    onClicked: {
                        stack.push(Qt.resolvedUrl("pages/Settings.qml"));
                    }
                }
                MenuItem {
                    text: qsTr("Exit")
                    onClicked: {
                        windowHelper.disableSwype(false);
                        Qt.quit();
                    }
                }
            }
        }
    }*/

    /*ToolBarLayout {
        id: commonTools
        ToolIcon {
            iconId: stack.depth > 1 ? "toolbar-back" : "toolbar-back-dimmed"//toolbar-refresh"
            //iconId: "toolbar-back"
            onClicked: {
                if (stack.depth > 1)
                    stack.pop();
            }
        }
        ButtonRow {
            style: TabButtonStyle {}

            TabButtonIcon {
                platformIconId: "toolbar-home"
                tab: tabFeed
                onClicked: popToTop(tabFeed);
            }
            TabButtonIcon {
                //platformIconId: "toolbar-venues" //TODO: add icons to theme extension
                iconSource: "icons/icon-m-toolbar-venues".concat(theme.inverted ? "-white" : "").concat(".png")
                tab: tabVenues
                onClicked: popToTop(tabVenues);
            }
            TabButtonIcon {
                platformIconId: "toolbar-contact"
                tab: tabMe
                onClicked: popToTop(tabMe);
            }
        }

        ToolIcon {
            platformIconId: "toolbar-view-menu"
            onClicked: {
                if (stack.currentPage.pageMenu !== undefined) {
                    stack.currentPage.pageMenu.open();
                } else {
                    dummyMenu.createObject(mainPage).open();
                }
            }
        }
    }*/

    /*
    //TODO: no updates
    Timer {
        id: updateTimer
        repeat: true
        interval: 600 * 1000
        onTriggered: {
            appConfig.checkUpdates();
        }

    }*/

    AppConfig {
        id: appConfig

        onSettingsLoaded: {
            //CheckUpdates, RunUpdateTimer
            /*
            if (interfaceLanguage === "") {
                console.log("Loading default language");
                interfaceLanguage = translator.getDefaultLanguage();
            }*/
            /*if (gpsAllow === "") {
                locationAllowDialog.open();
            }
            if (pushEnable === "") {
                pushNotificationDialog.open();
            }*/
        }
        onSettingsReseted: {
            cache.reset()
        }

        onInterfaceOrientationChanged: appWindow.lockWindowOrientation(interfaceOrientation)
        onInterfaceImageLoadChanged: cache.loadtype(interfaceImageLoad)
        onInterfaceThemeChanged: mytheme.loadTheme(interfaceTheme)
        onInterfaceDisableSwypeDownChanged: windowHelper.disableSwype(interfaceDisableSwypeDown === "1")
        onInterfaceLanguageChanged: {
            Api.setLocale(interfaceLanguage.substring(0,2));
            //TODO: translator.changeLanguage(interfaceLanguage);
        }

        onDebugEnabledChanged: Api.api.debugenabled = debugEnabled;
        onDebugFeedChanged: Api.feed.debuglevel = debugFeed;
        onDebugCheckinsChanged: Api.checkin.debuglevel = debugCheckins
        onDebugNotisChanged: Api.notifications.debuglevel = debugNotis
        onDebugPhotosChanged: Api.photos.debuglevel = debugPhotos
        onDebugTipsChanged: Api.tips.debuglevel = debugTips
        onDebugUsersChanged: Api.users.debuglevel = debugUsers
        onDebugVenuesChanged: Api.venues.debuglevel = debugVenues

        onUpdatesCheckChanged: {
            if (updatesCheck!="none") {
                updateTimer.restart();
            } else {
                updateTimer.stop();
            }
        }

        onFoursquareAccessTokenChanged: {
            Api.setAccessToken(foursquareAccessToken)
            //console.log("AUTH TOKEN CHANGED:", foursquareAccessToken);
            //TODO: change does not work, maybe change to stack.replace();
            if(foursquareAccessToken.length>0) {
                initialPage = friendsFeedPage;
                //windowHelper.disableSwype(appConfig.interfaceDisableSwypeDown === "1");
            } else {
                initialPage = welcomePage;
                //windowHelper.disableSwype(false);
            }
        }
    }

    ThemeLoader {
        id: myTheme
    }

    RemorsePopup {
        id: remorsePopup
    }

    Timer {
        id: timerGPSUnlock
        interval: appConfig.gpsUnlockTime * 1000;
        repeat: false
        onTriggered: {
            positionSource.active = appWindow.windowActive;
        }
    }

    PositionSource {
        id: positionSource
        updateInterval: 1000
        active: false
    }

    function sendDebugInfo(object) {
        pageStack.push(Qt.resolvedUrl("pages/DebugSubmit.qml"), {"contentdata": {"DebugWidget":object}});
    }

    /*function openStartPage() {
        switch(appConfig.interfaceStartPage) {
        case "self":
            tabgroup.currentTab = tabMe;
            break;
        case "venues":
            tabgroup.currentTab = tabVenues;
            break;
        case "feed":
        default:
            tabgroup.currentTab = tabFeed;
            break;
        }
    }*/

    /*function processUINotification(id) {
        stack.push(Qt.resolvedUrl("pages/Notifications.qml"));
    }*/

    //TODO: move to object and make part of DBusServer object
    /*function processURI(url) {
        console.log("uri: " + url);
        var params = url.split("/");
        var type = params[0];
        var id = params[1];
        popToTop(tabgroup.currentTab);
        switch(type) {
        case "start":
            openStartPage();
            if (id === "top") {
                popToTop(tabgroup.currentTab);
            }
            break;
        case "friend":
            stack.push(Qt.resolvedUrl("pages/User.qml"),{"userID":id});
            break;
        case "checkin":
            stack.push(Qt.resolvedUrl("pages/Checkin.qml"),{"checkinID":id});
            break;
        case "savetip":
        case "tip":
            stack.push(Qt.resolvedUrl("pages/TipPage.qml"), {"tipID":id});
            break;
        case "savevenue":
        case "likevenue":
            stack.push(Qt.resolvedUrl("pages/Venue.qml"), {"venueID":id});
            break;
        //TODO: ? how to treat badges?
        case "awardbadge":
        //TODO: implement theese as pages will be available
        case "installplugin":
        case "likepage":
        case "pageupdate":
        case "likepageupdate":
        case "savelist":
        default:
            console.log("Unimplemented feed callback for content: " + type);
            break;
        }
    }*/

    function cacheUpdated(callbackObject, status, url) {
        //console.log("Cache update callback: type: " + typeof(callbackObject) + " status: " + status + " url: " + url );
        try {
            if (typeof(callbackObject) === "function") {
                //console.log("funtion!");
                callbackObject(status,url);
            } else if (typeof(callbackObject) === "object") {
                //console.log("object!");
                if (callbackObject.cacheCallback !== undefined) {
                    callbackObject.cacheCallback(status,url);
                } else {
                    console.log("object callback is undefined!");
                }
            } else if (typeof(callbackObject) === "string") {
                //console.log("string!");
                var obj = Api.objs.get(callbackObject);
                if (obj.cacheCallback !== undefined) {
                    obj.cacheCallback(status,url);
                } else {
                    console.log("object callback is undefined!");
                }
                Api.objs.remove(callbackObject);
            } else {
                console.log("type is: " + typeof(callbackObject));
            }
        } catch (err) {
            console.log("Cache callback error: " + err + " type: " + typeof(callbackObject) + " value: " + JSON.stringify(callbackObject) );
        }
    }
    Connections {
       target: imageCache
       onCacheUpdated: appWindow.cacheUpdated(callback, status, url)
    }

    /*function reloadUI() {
        platformUtils.clearFeed();
        tabLogin.clear();
        tabFeed.clear();
        tabVenues.clear();
        tabMe.clear();
        tabgroup.currentTab.load();
    }

    //TODO: Move to HttpUpload with parsing
    function onPictureUploaded(response, page) {
        Api.photos.parseAddPhoto(response, page);
    }

    Connections {
        target: translator
        onLanguageChanged: {
            reloadUI();
        }
    }*/

    /*function lockWindowOrientation(value) {
        if (value === "auto") {
            mainPage.orientationLock = PageOrientation.Automatic
        } else if (value === "landscape") {
            mainPage.orientationLock = PageOrientation.LockLandscape
        } else if (value === "portrait") {
            mainPage.orientationLock = PageOrientation.LockPortrait
        }
    }*/

    /*QueryDialog  {
        id: locationAllowDialog
        icon: "image://theme/icon-m-common-location-selected"
        titleText: qsTr("Location data")
        message: qsTr("Nelisquare requires use of user location data. Data is needed to make geo-location services work properly.")
        acceptButtonText: qsTr("Allow")
        rejectButtonText: qsTr("Deny")
        onAccepted: {
            appConfig.gpsAllow = "1";
        }
        onRejected: {
            appConfig.gpsAllow = "0";
        }
    }

    QueryDialog  {
        id: pushNotificationDialog
        icon: "image://theme/icon-m-settings-notification"
        titleText: qsTr("Push notifications")
        message: qsTr("Incoming push notifications are not supported at this version and are disabled by default.<br/><br/>You will be promted again when they will be available at future versions.")
        onAccepted: {
            appConfig.pushEnable = "0";
        }
        acceptButtonText: qsTr("OK")
    }*/
}
