import QtQuick 2.0

import "../components"
import "../js/utils.js" as Utils

Item {
    id: eventItem

    signal userClicked()
    signal areaClicked()
    signal areaPressAndHold()

    property variant object

    //Old Values
    property string objectId: object.content.object.id
    property string summaryText: object.summary.text
    property string userPhoto: object.thumbnails[0].photo
    property string friendPhoto: Utils.makeUserPhoto(object.content.object.photo)
    property string createdAt: Utils.makeTime(object.createdAt)

    property bool activeWhole: true

    width: parent.width
    height: Math.max(statusTextArea.height,profileImage.height)

    ProfilePhoto {
        id: profileImage
        masked: true
        photoUrl: userPhoto

        onClicked: {
            eventItem.userClicked();
        }
    }

    ProfilePhoto {
        id: friendImage
        masked: true
        anchors {
            right: parent.right
            rightMargin: myTheme.paddingMedium
        }

        photoUrl: friendPhoto

        onClicked: {
            eventItem.userClicked();
        }
    }

    Column {
        id: statusTextArea
        spacing: 4
        anchors {
            left: profileImage.right
            leftMargin: 12
            right: friendImage.left
            rightMargin: 12
        }

        Text {
            id: messageText
            color: myTheme.highlightColor
            font.pixelSize: myTheme.fontSizeMedium
            width: parent.width
            text: summaryText
            wrapMode: Text.Wrap
            visible: messageText.text != ""
        }

        Text {
            color: myTheme.secondaryColor
            font.pixelSize: myTheme.fontSizeSmall
            text: createdAt
            wrapMode: Text.Wrap
            visible: createdAt.length>0
        }
    }

    MouseArea {
        id: mouseArea
        anchors.fill: parent
        onClicked: {
            eventItem.areaClicked();
        }
        onPressAndHold: {
            eventItem.areaPressAndHold();
        }
    }
}
