import QtQuick 2.0

import "../components"
import "../js/utils.js" as Utils

Item {
    id: eventItem

    signal userClicked()
    signal areaClicked()
    signal areaPressAndHold()

    property variant object

    property string objectId: object.content.object.id
    property string summaryText: object.summary.text
    property string userPhoto: object.thumbnails[0].photo
    property string createdAt: Utils.makeTime(object.createdAt)

    property bool activeWhole: true

    width: parent.width
    height: Math.max(statusTextArea.height,profileImage.height)

    onObjectChanged: {
        object.content.object.items.forEach(function(item){
            eventsModel.append({"item":item});
        });
    }

    ListModel {
        id: eventsModel
    }

    ProfilePhoto {
        id: profileImage
        masked: true
        photoUrl: userPhoto

        onClicked: {
            eventItem.userClicked();
        }
    }

    Column {
        id: statusTextArea
        spacing: 4
        anchors {
            left: profileImage.right
            leftMargin: myTheme.paddingMedium
            right: parent.right
            rightMargin: myTheme.paddingMedium
        }

        Text {
            id: messageText
            color: myTheme.highlightColor
            font.pixelSize: myTheme.fontSizeMedium
            width: parent.width
            text: summaryText
            wrapMode: Text.Wrap
            visible: messageText.text != ""
        }
        Repeater {
            width: parent.width
            model: eventsModel
            delegate: eventDelegate
        }

        Text {
            color: myTheme.secondaryColor
            font.pixelSize: myTheme.fontSizeSmall
            text: createdAt
            wrapMode: Text.Wrap
            visible: createdAt.length>0
        }
    }

    Component {
        id: eventDelegate

        Loader {
            width: statusTextArea.width

            function getDelegateByType(type) {
                if (type === "checkin") {
                    return aggregateDelegateCheckin;
                }
                console.log("AGGREGATE ITEM TYPE:", type);
                return aggregateDelegateUnknown;
            }
            property variant content: model.item
            sourceComponent: getDelegateByType(model.item.type);

        }
    }

    Component {
        id: aggregateDelegateCheckin

        DelegateCheckinVenue {
            object: content.object
        }
    }

    Component {
        id: aggregateDelegateUnknown

        DebugWidget {
            debugType: content.type ? content.type : "unknown"
            debugContent: content
        }
    }

    MouseArea {
        id: mouseArea
        anchors.fill: parent
        onClicked: {
            eventItem.areaClicked();
        }
        onPressAndHold: {
            eventItem.areaPressAndHold();
        }
    }
}
