import QtQuick 2.0

Item {
    id: progress
    property int value: 0
    property int minimumValue: 0
    property int maximumValue: 100
    property string types: ""
    property bool showPercent: false
    property int radiusValue: 0
    property bool indeterminate: false

    width: parent.width
    height: 32

    Rectangle {
        anchors.left: parent.left
        anchors.top: parent.top
        radius: radiusValue
        height: parent.height
        width: parent.width
        color: myTheme.secondaryColor
        visible: !indeterminate
    }
    Rectangle {
        anchors.left: parent.left
        anchors.top: parent.top
        radius: radiusValue
        height: parent.height
        width: parent.width * value / (maximumValue - minimumValue)
        color: myTheme.secondaryHighlightColor
        onWidthChanged: {
            if (width > 50) {
                percentText.anchors.left = undefined;
                percentText.anchors.right = right;
                percentText.color = myTheme.primaryColor;
            } else {
                percentText.anchors.right = undefined;
                percentText.anchors.left = right;
                percentText.color = myTheme.primaryColor;
            }
        }
        Text {
            id: percentText
            text: "  " + value + progress.types + "  "
            font.pixelSize: myTheme.fontSizeSmall
            anchors.verticalCenter: parent.verticalCenter
            color: myTheme.secondaryColor
            visible: showPercent>0
        }
        visible: !indeterminate
    }
    Image {
        id: loader
        source: "../pics/waiting.gif"
        width: parent.width
        //height: parent.height
        anchors.centerIn: parent
        visible: indeterminate
    }
}
