import QtQuick 1.0

Rectangle {
    id: button
    width: 100
    height: 50
    property string label: "-"
    signal clicked()
    radius: 6
    property bool pressed: false

    smooth: true
    border.color: mouse.pressed ? "#17649A" : "#3784cA"
    border.width: button.pressed ? 0 : 2
    gradient: button.pressed ? pressedColor : (mouse.pressed ? pressedColor : idleColor)

    Gradient {
        id: idleColor
        GradientStop{position: 0; color: "#19548A"; }
        GradientStop{position: 0.1; color: "#2774bA"; }
        GradientStop{position: 0.6; color: "#17649A"; }
        GradientStop{position: 0.9; color: "#3784cA"; }
    }

    Gradient {
        id: pressedColor
        GradientStop{position: 0; color: "#10446A"; }
        GradientStop{position: 0.1; color: "#17548A"; }
        GradientStop{position: 0.6; color: "#17447A"; }
        GradientStop{position: 0.9; color: "#2060a0"; }
    }

    Text {
        text: button.label
        font.pixelSize: 24
        color: "#fff"
        anchors.centerIn: parent
    }

    MouseArea {
        id: mouse
        anchors.fill: parent
        onClicked: button.clicked();
    }
}
