/*
 * This file is part of NeHeGLES.
 *
 * NeHeGLES is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * NeHeGLES is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NeHeGLES.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>

#ifdef USE_MAEMO
#include <libosso.h>
#endif

#include "config.h"
#include "menu.h"
#include "list.h"

static void on_window_destroy (GtkWidget *widget, gpointer data) {
#ifdef USE_MAEMO
  osso_context_t *osso_context = 
    g_object_get_data(G_OBJECT(widget), "osso-context");
  g_assert(osso_context);

  if(osso_context)
    osso_deinitialize(osso_context);
#endif

  gtk_main_quit();
}

int main(int argc, char *argv[]) {

  gtk_init (&argc, &argv);

#ifdef USE_MAEMO
  /* Create the hildon program and setup the title */
  HildonProgram *program = HILDON_PROGRAM(hildon_program_get_instance());
  g_set_application_name("NeHeGLES");
  
  /* Create HildonWindow and set it to HildonProgram */
#ifdef MAEMO5
  GtkWidget *window = hildon_stackable_window_new();
#else
  GtkWidget *window = hildon_window_new();
#endif

  hildon_program_add_window(program, HILDON_WINDOW(window));

  g_object_set_data(G_OBJECT(window), "osso-context",
	    osso_initialize("org.harbaum."APP, VERSION, TRUE, NULL));

#if MAEMO_VERSION_MAJOR >= 5
  gtk_window_set_title(GTK_WINDOW(window), "NeHeGLES");
#endif // MAEMO_VERSION

#else
  /* Create a Window. */
  GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  /* Set a decent default size for the window. */
  gtk_window_set_default_size(GTK_WINDOW(window), 640, 480);

  gtk_window_set_title(GTK_WINDOW(window), "NeHeGLES");
#endif

  g_signal_connect(G_OBJECT(window), "destroy", 
		   G_CALLBACK(on_window_destroy), NULL);

  GtkWidget *vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), vbox);

  GtkWidget *list = list_new();

  /* attach menu to main window */
  menu_create(vbox, list);

  gtk_box_pack_start_defaults(GTK_BOX(vbox), list);

  gtk_widget_show_all(GTK_WIDGET(window));
  gtk_main();

  return 0;
}
