#ifndef UILIBRARY_H
#define UILIBRARY_H

#include <QtGui>

class Player;

class UILibrary : public QWidget
{
    Q_OBJECT
public:
    /*
   * Constructor
   */
    UILibrary(Player* parent, QString& musicPath, QString& musicName);
    ~UILibrary();

    /*
   * Refresh the content with a new music path
   */
    bool fileIsGood(QString uri);
    void refreshWithNewMusicPath(int i);
    void setPreviousPlaylistCount();

    QString& getMusicPath()
    {
        return musicPath;
    }

    QString& getMusicName()
    {
        return musicName;
    }

    void musicPathDir0SetText();

public slots:
    void folderBackToRoot();
    void folderBack();
    void folderListDoubleClicked(QListWidgetItem* item);
    void deselectItem();
    void enableSelection();
    void addAndPlay();
    /*
   * When the user clicks in the menu, on the item Add folder to playlist
   */
    void slotAddFolder(bool autoplay, bool replaced);
    /*
   * When the user clicks in the menu, on the item Replace in playlist
   */
    void slotReplFolder(bool autoplay);

    QListWidgetItem* currentItem();

    //protected:
    //void contextMenuEvent(QContextMenuEvent* event);

private:
    QListWidget* listWidget;
    QListWidgetItem* previousItem;

    QHBoxLayout* layout;

    QSignalMapper* signalMapper;
    QSignalMapper* signalMapper2;

    QString musicPath;
    QString musicName;
    QString musicPathRel;
    QString musicDir;
    QString musicDirName;
    QString dirEntry;
    QStringList dirContent;

    QStringList filters;
    QStringList musicPathDirList;
    QPushButton * musicPathDir0;

    QDialog * contentDialog;
    QVBoxLayout * dialogLayout;
    QScrollArea * contentArea;
    QWidget * contentWidget;
    QVBoxLayout * contentLayout;
    QList<QPushButton *> contents;

    void selectContent();
    int refreshDirContent();
    int previousPlaylistCount;

    void addFile(QString uri);
    void addFolder(QString uri);
    QStringList getMediaFilesInDir(QString uri);
    bool itemDeselected;

    QString trSelectView;

    Player* parent;

private slots:
    void musicPathDir0Released();
    void musicPathDir0EnableAutoRepeat();
    void musicPathDirClicked(int n);
    void changeContent(int i);
    void folderListClicked(QListWidgetItem* item);
};

#endif // UILIBRARY_H
