#include <iostream>
#include <QtGui>
#include "DelegateFolder.h"
#include "Player.h"

UILibrary::UILibrary(Player* parent, QString& musicPath, QString& musicName)
{
    this->parent = parent;

    trSelectView = tr("Select view");


    listWidget = new QListWidget;
    listWidget->setAlternatingRowColors(true);
    listWidget->setItemDelegate(new DelegateFolder(listWidget));


    layout = new QHBoxLayout;
    layout->setMargin(0);
    layout->addSpacing(10);
    layout->addWidget(listWidget);
    layout->addSpacing(8);

    this->musicName = musicName;
    this->musicPath = musicPath;
    musicDir = musicPath;
    QFileInfo dirInfo(musicDir);
    musicDirName = dirInfo.fileName();

    musicPathDir0 = new QPushButton();
    musicPathDir0->setFixedHeight(58);
    musicPathDir0->setIcon(QIcon("/opt/necroplayer2/icons/32x32/folders.png"));
    musicPathDir0->setAutoRepeat(true);
    musicPathDir0->setAutoRepeatDelay(1000);
    musicPathDir0->setAutoRepeatInterval(1000);

    signalMapper = new QSignalMapper(this);
    signalMapper->setMapping(musicPathDir0, 0);

    connect(signalMapper, SIGNAL(mapped(int)), this, SLOT(musicPathDirClicked(int)));

    connect(listWidget, SIGNAL(itemClicked(QListWidgetItem*)),
            SLOT(folderListClicked(QListWidgetItem*)));
    connect(listWidget, SIGNAL(itemDoubleClicked(QListWidgetItem*)),
            SLOT(folderListDoubleClicked(QListWidgetItem*)));

    connect(musicPathDir0, SIGNAL(released()), SLOT(musicPathDir0Released()));
    connect(musicPathDir0, SIGNAL(clicked()), signalMapper, SLOT(map()));

    signalMapper2 = new QSignalMapper(this);
    connect(signalMapper2, SIGNAL(mapped(int)), this, SLOT(changeContent(int)));

    // Filters
    // Audios
    filters << "*.mp3" << "*.wav" << "*.wma" << "*.mpc" << "*.m4a" << "*.ogg" << "*.aac" << "*.flac";
    // Videos
    filters << "*.avi" << "*.mpg" << "*.mp4";
    // System
    //filters << "..";

    refreshDirContent();
    listWidget->scrollToTop();
    setLayout(layout);
}

UILibrary::~UILibrary()
{
    if (listWidget)
        delete listWidget;
    if(layout)
        delete layout;
}

int
UILibrary::refreshDirContent()
{
    int n=0;
    QDir tmp;
    if (musicPath == "")
    {
        tmp.setPath(NULL);
    }
    else
    {
        tmp.setPath(musicPath);
    }
    QListWidgetItem* item = NULL;
    //QStyle * style = parent->style();
    QStyle::StandardPixmap icon;
    QFileInfo fi;

    tmp.setSorting(QDir::DirsFirst | QDir::IgnoreCase);
    if (parent->config->showHidden)
        tmp.setFilter(QDir::AllDirs | QDir::Files | QDir::Hidden );
    else
        tmp.setFilter(QDir::AllDirs | QDir::Files);

    tmp.setNameFilters(filters);

    listWidget->clear();
    dirContent = tmp.entryList();

    musicPathRel = musicPath;
    musicPathRel.remove(0, musicDir.size()-musicDirName.size());
    item = new QListWidgetItem();
    item->setFlags(item->flags() & ~Qt::ItemIsEnabled);

    QScrollArea* musicPathArea = new QScrollArea();
    musicPathArea->setWidgetResizable(true);
    musicPathArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    musicPathArea->setContentsMargins(0, 0, 0, 0);
    QWidget* musicPathWidget = new QWidget();
    QHBoxLayout* musicPathLayout = new QHBoxLayout();
    musicPathLayout->setAlignment(Qt::AlignLeft);
    musicPathLayout->setSpacing(4);
    musicPathLayout->setMargin(0);

    musicPathDirList = musicPathRel.split("/");

    QPushButton* musicPathDir[musicPathDirList.size() - 1];
    int i = -1;
    musicPathLayout->addWidget(musicPathDir0);
    foreach (const QString &str, musicPathDirList)
    {
        i += 1;
        if (i)
        {
            musicPathDir[i] = new QPushButton();
            musicPathDir[i]->setFixedHeight(58);
            musicPathDir[i]->setText(" " + str + " ");
            if (i < musicPathDirList.size() - 1)
            {
                connect(musicPathDir[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
                signalMapper->setMapping(musicPathDir[i], i);
            }
            musicPathLayout->addWidget(musicPathDir[i]);
        }
        else
        {
            musicPathDir0SetText();
        }
    }
    musicPathWidget->setLayout(musicPathLayout);
    musicPathArea->setWidget(musicPathWidget);

    listWidget->addItem(item);
    listWidget->setItemWidget(item, musicPathArea);

    if (i && musicPathWidget->width() > 767)
    {
        musicPathArea->setVisible(false);
        parent->processEvents();
        musicPathArea->setVisible(true);
        musicPathArea->ensureWidgetVisible(musicPathDir[i]);
    }

    for (int i = 1; i < dirContent.count(); i++)
    {
        fi.setFile(musicPath+"/"+dirContent[i]);
        if (fi.fileName()==".") continue;

        if (fi.isDir())
        {
            icon = QStyle::SP_DirIcon;
        }
        else
        {
            icon = QStyle::SP_FileIcon;
        }

        item = new QListWidgetItem();
        item->setData(UserRoleFolderItem, dirContent[i]);
        if (item)
        {
            if (item->data(UserRoleFolderItem) != "..")
            {
                listWidget->addItem(item);
            }
            n++;
        }
    }
    return n;
}

void
UILibrary::musicPathDir0SetText()
{
    if (parent->config->showDescriptions)
    {
        if (parent->config->musicIndex ||
            !parent->config->hideFirstDescription)
        {
            musicPathDir0->setText(" " + parent->config->musicDescriptions[parent->
                                   config->musicIndex] + " ");
            musicPathDir0->setMinimumWidth(QWIDGETSIZE_MAX);
        }
        else
        {
            musicPathDir0->setText("");
            musicPathDir0->setMinimumWidth(108);
        }
    }
    else
    {
        musicPathDir0->setText("");
        musicPathDir0->setMinimumWidth(108);
    }
}

void
UILibrary::musicPathDirClicked(int n)
{
    if (!n)
    {
        if (musicPathDir0->isDown())
        {
            musicPathDir0->setAutoRepeat(false);
            selectContent();
            return;
        }
        if (!musicPathDir0->autoRepeat())
        {
            return;
        }
    }
    if (musicPathDirList.size() > 1)
    {
        QString oldDir = musicPathDirList[n+1];
        QString oldPath = musicPath;
        musicPath = musicDir;
        for (int i = 1; i <= n; i++)
        {
            musicPath += "/" + musicPathDirList[i];
        }
        if (!refreshDirContent()) //bad permission to this dir
        {
            musicPath=oldPath;
            musicPath = QDir::cleanPath(musicPath);
            refreshDirContent();
        }
        for (int i=1; i < dirContent.count(); i++)
        {
            if (dirContent[i] == oldDir)
            {
                listWidget->scrollToItem(listWidget->item(i-1), QAbstractItemView::PositionAtCenter);
                listWidget->setCurrentRow(i-1);
                previousItem = listWidget->item(i-1);
                itemDeselected = false;
                break;
            }
        }
    }
    else
    {
        selectContent();
    }
}

void
UILibrary::musicPathDir0Released()
{
    if (!musicPathDir0->autoRepeat())
    {
        QMetaObject::invokeMethod(this, "musicPathDir0EnableAutoRepeat", Qt::QueuedConnection);
    }
}

void
UILibrary::musicPathDir0EnableAutoRepeat()
{
    musicPathDir0->setAutoRepeat(true);
}

void
UILibrary::selectContent()
{
    contentDialog = new QDialog(this);
    contentDialog->setWindowTitle(trSelectView);
    dialogLayout = new QVBoxLayout();
    dialogLayout->setAlignment(Qt::AlignCenter);

    contentArea = new QScrollArea();
    contentWidget = new QWidget();
    contentArea->setWidget(contentWidget);
    contentArea->setWidgetResizable(true);
//    contentArea->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Expanding);
    contentArea->setFixedWidth(766);
    contentLayout = new QVBoxLayout();
    contentLayout->setAlignment(Qt::AlignCenter);
    contents.clear();

    int i = -1;
    foreach(QString musicDescription, parent->config->musicDescriptions)
    {
        i += 1;
        contents.append(new QPushButton(QIcon("/opt/necroplayer2/icons/32x32/folders.png"), musicDescription));
        contents[i]->setFixedWidth(724);
        if (i == parent->config->musicIndex)
        {
            contents[i]->setEnabled(false);
        }
        else
        {
            contents[i]->setEnabled(true);
        }
        connect(contents[i], SIGNAL(clicked()), signalMapper2, SLOT(map()));
        signalMapper2->setMapping(contents[i], i);
        contentLayout->addWidget(contents[i]);
    }

    contentWidget->setLayout(contentLayout);
    dialogLayout->addWidget(contentArea);
    contentDialog->setLayout(dialogLayout);

    contentDialog->show();
}

void
UILibrary::changeContent(int i)
{
    parent->config->musicIndex = i;
    refreshWithNewMusicPath(i);
    contentDialog->close();
}

void
UILibrary::folderBackToRoot()
{
    QString oldPath = musicPath;
    musicPath = musicDir;
    if (!refreshDirContent()) //bad permission to this dir
    {
        musicPath=oldPath;
        musicPath = QDir::cleanPath(musicPath);
        refreshDirContent();
    }
}

void
UILibrary::folderBack()
{
    if (musicPath != musicDir)
    {
        QFileInfo dirInfo(musicPath);
        QString oldPath = musicPath;
        musicPath += "/..";
        musicPath = QDir::cleanPath(musicPath);
        if (!refreshDirContent()) //bad permission to this dir
        {
            musicPath=oldPath;
            musicPath = QDir::cleanPath(musicPath);
            refreshDirContent();
        }
        for (int i=1; i < dirContent.count(); i++)
        {
            if (dirContent[i] == dirInfo.fileName())
            {
                listWidget->scrollToItem(listWidget->item(i-1), QAbstractItemView::PositionAtCenter);
                listWidget->setCurrentRow(i-1);
                previousItem = listWidget->item(i-1);
                itemDeselected = false;
                break;
            }
        }
    }
}

void
UILibrary::folderListClicked(QListWidgetItem* item)
{
    if (!item or listWidget->row(item) == 0)
        return;

    if (previousItem == item && !itemDeselected)
    {
        QMetaObject::invokeMethod(this, "deselectItem", Qt::QueuedConnection);
        itemDeselected = true;
    }
    else if (previousItem != item)
    {
        previousItem = item;
        itemDeselected = false;
    }
    else if (itemDeselected)
        itemDeselected = false;
}

void
UILibrary::folderListDoubleClicked(QListWidgetItem* item)
{
    QString s = musicPath + "/" + dirContent[listWidget->row(item) + 1];
    QFileInfo fi;

    fi.setFile(s);

    if (fi.isDir())
    { // directory
        QString oldPath = musicPath;
        musicPath += "/" + dirContent[listWidget->row(item) + 1];
        musicPath = QDir::cleanPath(musicPath);
        listWidget->setSelectionMode(QAbstractItemView::NoSelection);
        if (!refreshDirContent()) //bad permission to this dir
        { //back
            musicPath=oldPath;
            musicPath = QDir::cleanPath(musicPath);
            refreshDirContent();
        }
        else
        {
            listWidget->scrollToTop();
            QTimer::singleShot(250, this, SLOT(enableSelection()));
        }
    }
    else
    {
        addFile(s);
    }
}

void
UILibrary::deselectItem()
{
    if (!listWidget->selectedItems().isEmpty())
    {
        listWidget->item(listWidget->row(currentItem()))->setSelected(false);
        itemDeselected = true;
    }
}

void
UILibrary::enableSelection()
{
    listWidget->setSelectionMode(QAbstractItemView::SingleSelection);
}

void
UILibrary::addFile(QString uri)
{
    if (fileIsGood(uri))
    {
        QStringList files;
        files.append(uri);
        parent->ui->playlistAdd(files);
    }
    QTimer::singleShot(250, this, SLOT(deselectItem()));
}

void
UILibrary::slotAddFolder(bool autoplay, bool replaced)
{
    // add the content of the dir
    if(currentItem())
    {
        if ((currentItem()->text() != "..")&&(currentItem()->text() != "."))
        {
            QString uri = musicPath + "/" + dirContent[listWidget->row(currentItem()) + 1];
            QFileInfo fi;
            if (autoplay && !replaced)
            {
                previousPlaylistCount = parent->ui->playlistCount();
            }
            else if (replaced)
            {
                previousPlaylistCount = 0;
            }
            fi.setFile(uri);
            if (fi.isDir())
            {
                parent->engine->setMetaInfosUpdating();
                addFolder(uri);
            }
            else
            {
                parent->engine->setMetaInfosUpdating();
                addFile(uri);
            }
            if (autoplay)
            {
                addAndPlay();
            }
        }
    }
}

void
UILibrary::setPreviousPlaylistCount()
{
    previousPlaylistCount = parent->ui->playlistCount();
}

void
UILibrary::addAndPlay()
{
    if (!parent->engine->getMetaInfosUpdating())
    {
        if (parent->ui->getPlaylist().getBoldRow() != -1)
        {
            parent->ui->getPlaylist().setBold(parent->ui->getPlaylist().getBoldRow(), false);
        }
        parent->ui->getPlaylist().setBold(previousPlaylistCount, true);
        parent->play(previousPlaylistCount, 0);
    }
    else
    {
        QTimer::singleShot(200, this, SLOT(addAndPlay()));
    }
}

void
UILibrary::slotReplFolder(bool autoplay)
{
    if(currentItem())
    {
        if ((currentItem()->text() != "..")&&(currentItem()->text() != "."))
        {
            parent->engine->clearPlayList();
            slotAddFolder(autoplay, true);
        }

    }
}

void UILibrary::addFolder(QString uri)
{
    QStringList files;
    files=getMediaFilesInDir(uri);
    parent->ui->playlistAdd(files);
    QTimer::singleShot(250, this, SLOT(deselectItem()));
}


QStringList UILibrary::getMediaFilesInDir(QString uri)
{
    QDir tmp(uri);
    QString s;
    QFileInfo fi;
    QStringList tmpDirContent = tmp.entryList();
    QStringList mFileList;
    int count = tmpDirContent.count();
    //   qDebug()<<tmpDirContent;
    //   return mFileList;

    for (int i = 0; i < count; i++)
    {
        if((tmpDirContent[i]=="..")||(tmpDirContent[i]=="."))
            continue;
        s = uri + "/" + tmpDirContent[i];
        fi.setFile(s);
        if(fi.isDir())
        {
            mFileList.append(getMediaFilesInDir(s));
        }
        else
        {
            if (fileIsGood(s))
            {
                mFileList.append(s);
            }
        }

    }
    return mFileList;
}

bool UILibrary::fileIsGood(QString uri)
{
    int nbFilters = filters.count();
    bool isGood = false;

    //  qDebug()<<uri;
    QString filter="";
    for (int i = 0; i < nbFilters;i++)
    {
        //qDebug()<<filters[i];
        filter = filters[i];

        if ((uri.endsWith(filter.remove(QRegExp("^[*]")),Qt::CaseInsensitive)) && (filters[i] != ".."))
        {
            isGood = true;
            break;
        }

    }
    return isGood;
}

void
UILibrary::refreshWithNewMusicPath(int i)
{
    if (parent->config->musicFolders.size())
    {
        musicPath = parent->config->musicFolders.at(i);
        musicName = parent->config->musicDescriptions.at(i);
        musicDir = musicPath;
        QFileInfo dirInfo(musicDir);
        musicDirName = dirInfo.fileName();
    }
    else
    {
        musicPath = "";
        musicName = "";
        musicDir = "";
        musicDirName = "";
    }
    refreshDirContent();
    listWidget->scrollToTop();
}

QListWidgetItem* UILibrary::currentItem()
{
    //the same hack, see UIPlaylist.cpp
    QListWidgetItem * item = 0;
    QList<QListWidgetItem *> list=listWidget->selectedItems();

    if(list.size()>0)
    {
        item=list.at(0);
    }

    return item;
}
