#include "UIControl3.h"
#include "Player.h"

UIControl3::UIControl3(Player* parent)
{
    this->parent = parent;

    // Control buttons
    //QStyle * s = parent->style();

    buttonBack = new QPushButton(QIcon("/opt/necroplayer2/icons/32x32/back.png"),"");
    buttonAdd = new QPushButton(QIcon("/opt/necroplayer2/icons/32x32/add.png"),"");
    buttonRepl = new QPushButton(QIcon("/opt/necroplayer2/icons/32x32/replace.png"),"");
    buttonBack->setFixedSize(108, 58);
    buttonAdd->setFixedSize(108, 58);
    buttonRepl->setFixedSize(108, 58);

    buttonBack->setAutoRepeat(true);
    buttonBack->setAutoRepeatDelay(1000);
    buttonBack->setAutoRepeatInterval(1000);

    buttonAdd->setAutoRepeat(true);
    buttonAdd->setAutoRepeatDelay(1000);
    buttonAdd->setAutoRepeatInterval(1000);

    buttonRepl->setAutoRepeat(true);
    buttonRepl->setAutoRepeatDelay(1000);
    buttonRepl->setAutoRepeatInterval(1000);

    layoutControl3 = new QHBoxLayout;
    layoutControl3->setSpacing(0);
    layoutControl3->setMargin(6);

    buttons = new QWidget();
    buttons->setFixedSize(374, 60);
    layoutControlButtons = new QHBoxLayout();
    layoutControlButtons->setSpacing(0);
    layoutControlButtons->setMargin(0);
    layoutControlButtons->addWidget(buttonBack);
    layoutControlButtons->addSpacing(40);
    layoutControlButtons->addWidget(buttonAdd);
    layoutControlButtons->addSpacing(10);
    layoutControlButtons->addWidget(buttonRepl);
    buttons->setLayout(layoutControlButtons);

    layoutControl3->addWidget(buttons);
    layoutControl3->addSpacing(2);

    connect(buttonBack, SIGNAL(clicked()), SLOT(folderBack()));
    connect(buttonAdd, SIGNAL(clicked()), SLOT(slotAddFolder()));
    connect(buttonRepl, SIGNAL(clicked()), SLOT(slotReplFolder()));

    connect(buttonBack, SIGNAL(released()), SLOT(buttonBackReleased()));
    connect(buttonAdd, SIGNAL(released()), SLOT(buttonAddReleased()));
    connect(buttonRepl, SIGNAL(released()), SLOT(buttonReplReleased()));

    this->setLayout(layoutControl3);
}

UIControl3::~UIControl3()
{
    if (buttonRepl)
        delete buttonRepl;
    if (buttonAdd)
        delete buttonAdd;
    if (buttonBack)
        delete buttonBack;
    if (layoutControl3)
        delete layoutControl3;
}

void
UIControl3::folderBack()
{
    if (buttonBack->isDown())
    {
        buttonBack->setAutoRepeat(false);
        parent->ui->folderBackToRoot();
    }
    else if (buttonBack->autoRepeat())
    {
        parent->ui->folderBack();
    }
}

void
UIControl3::slotAddFolder()
{
    if (buttonAdd->isDown())
    {
        buttonAdd->setAutoRepeat(false);
        parent->ui->slotAddFolder(true);
    }
    else if (buttonAdd->autoRepeat())
    {
        parent->ui->slotAddFolder(false);
    }
}

void
UIControl3::slotReplFolder()
{
    if (buttonRepl->isDown())
    {
        buttonRepl->setAutoRepeat(false);
        parent->ui->slotReplFolder(true);
    }
    else if (buttonRepl->autoRepeat())
    {
        parent->ui->slotReplFolder(false);
    }
}

void
UIControl3::buttonBackReleased()
{
    if (!buttonBack->autoRepeat())
        QMetaObject::invokeMethod(this, "buttonBackEnableAutoRepeat", Qt::QueuedConnection);
}

void
UIControl3::buttonBackEnableAutoRepeat()
{
    buttonBack->setAutoRepeat(true);
}

void
UIControl3::buttonAddReleased()
{
    if (!buttonAdd->autoRepeat())
        QMetaObject::invokeMethod(this, "buttonAddEnableAutoRepeat", Qt::QueuedConnection);
}

void
UIControl3::buttonAddEnableAutoRepeat()
{
    buttonAdd->setAutoRepeat(true);
}

void
UIControl3::buttonReplReleased()
{
    if (!buttonRepl->autoRepeat())
        QMetaObject::invokeMethod(this, "buttonReplEnableAutoRepeat", Qt::QueuedConnection);
}

void
UIControl3::buttonReplEnableAutoRepeat()
{
    buttonRepl->setAutoRepeat(true);
}
