#ifndef UICONTROL_H
#define UICONTROL_H

#include <QtGui>
#include <phonon/mediaobject.h>

class Player;

class UIControl : public QWidget
{
    Q_OBJECT

public:
    UIControl(Player* parent);
    ~UIControl();

    void setPlayIcon(Phonon::State s);
    void blockButtons();
    void unblockButtons();

public slots:
    void play();
    void next();
    void prev();
    void stop();

private:
    QPushButton *buttonPrev, *buttonStop, *buttonPlay, *buttonNext;

    QHBoxLayout *layoutControl1;

    Player* parent;

};

#endif // UICONTROL_H
