#ifndef SIMPLEVIEW_H
#define SIMPLEVIEW_H

#include <QtGui>
#include "UIControl.h"
#include "SimpleViewFM.h"


class UI;

class SimpleView : public QWidget
{
    Q_OBJECT

public:
    SimpleView(UI *parent);
    ~SimpleView();

    void infosSongSetText(QString s);
    void setPlayIcon(Phonon::State s);
    void blockButtons();
    void unblockButtons();


private:
    QGridLayout *simpleLayout;
    QFrame *infosFrame;
    QHBoxLayout *infosFrameLayout, *seekFMLayout;
    QToolButton *infosSong;
    QPushButton *buttonPrev, *buttonStop, *buttonPlay, *buttonNext, *buttonFM;
    QHBoxLayout *layoutControl;
    SimpleViewFM *simpleviewfm;

    bool getFMStatus();

    UI *parent;

private slots:
    void infosSongPressed();
    void infosSongReleased();
    void infosSongEnableAutoRepeat();
    void simpleViewHide();
    void play();
    void stop();
    void next();
    void prev();
    void onFMChanged();
    void buttonFMReleased();
    void buttonFMEnableAutoRepeat();
    void buttonFMClicked();
};

#endif // SIMPLEVIEW_H
