#ifndef UIPLAYLIST_H
#define UIPLAYLIST_H

#include <QtCore>
#include <QtGui>

class Player;

class UIPlaylist : public QWidget
{
    Q_OBJECT
public:
    /*
                 * Constructor
                 */
    UIPlaylist(Player* parent);

    ~UIPlaylist();

    /*
                 * Return the playlist widget
                 */
    QListWidget* getWidget()
    {
        return widgetPlaylist;
    }

    int getBoldRow()
    {
        return boldRow;
    }

    void unsetBoldRow();

    int selectedRow();

    void setTransparentBackground();
    void addItem(QString s);
    void changeItem(QString title, QString artist, QString totalTime, int row, short status);

public slots:
    void clearPlaylist(); // clear the widget
    void buttonClearPlaylist(); // clear the content & the widget
    void playlistClicked(QListWidgetItem*);
    void playlistDoubleClicked();
    void delItem();
    void upItem();
    void topItem();
    void downItem();
    void bottomItem();
    void setBold(unsigned int row, bool b);

private:
    QListWidget* widgetPlaylist;
    QListWidgetItem* previousItem;
    QHBoxLayout* layout;

    int boldRow;
    bool itemDeselected;

    QDialog* clearPlaylistDialog;
    QHBoxLayout* layoutConfirm;
    QPushButton* buttonConfirmClearPL;

    QString trClearPlaylist;

    Player* parent;

private slots:
    void buttonConfirmedClearPL();
};

#endif // UIPLAYLIST_H
