#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QtCore>
#include <QtGui>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include "Config.h"

class UI;

class SettingsDialog : public QWidget
{
    Q_OBJECT
public:
    SettingsDialog(UI *parent);
    ~SettingsDialog();
    void setConfig(Config *inputConfig);
    void getConfig(Config *outputConfig);

private:
    QSignalMapper *signalMapper;
    QSignalMapper *signalMapper2;
    QHBoxLayout *configLayout;

    QHBoxLayout *volLayout;
    QHBoxLayout *tagsLayout;
    QHBoxLayout *tagsOptLayout;
    QHBoxLayout *backgroundLayout;
    QVBoxLayout *scrollLayout;
    QWidget *scrollW;

    QScrollArea *scrArea;

//    QCheckBox *defaultPlayer;

    QGroupBox *playerBox;
    QVBoxLayout *playerLayout;
    QLabel *labelVolume;
    QLabel *labelPlaylist;
    QLabel *labelMetadata;
    QLabel *labelBackground;
    QLabel *labelFooter;
    QButtonGroup *useSysVolOrAppVol;
    QRadioButton *useSysVol;
    QRadioButton *useAppVol;
    QButtonGroup *useTagsOrNames;
    QRadioButton *useTags;
    QRadioButton *useFileNames;

    QButtonGroup *updateOnAddingOrPlaying;
    QRadioButton *updateOnAdding;
    QRadioButton *updateOnPlaying;

    QButtonGroup *playlistBackground;
    QRadioButton *showSeparators;
    QRadioButton *showBackground;

    QCheckBox *savePositionOnQuit;
    QCheckBox *pauseOnUnplugged;
    QCheckBox *resumeOnPlugged;
    QMaemo5ValueButton *phoneButtonFn;
    QMaemo5ListPickSelector *phoneButtonFnSelector;
    QStandardItemModel *model;

    QVBoxLayout *directoryLayout;
    QList<QHBoxLayout *> directoryLayouts;
    QGroupBox *directoryBox;

    QLabel *labelDirectory;
    QList<QMaemo5ValueButton *> directories;
    QList<QToolButton *> buttonDirsDel;
    QHBoxLayout *buttonDirsAddLayout;
    QToolButton *buttonDirsAdd;

    QDialog *folderDialog;
    QGridLayout *folderLayout;
    QLabel *folderCustomNameLabel;
    QLineEdit *folderCustomName;
    QMaemo5ValueButton *folderIndex;
    QMaemo5ListPickSelector *folderIndexSelector;
    QListWidget *indexList;
    QLabel *folderPathLabel;
    QLineEdit *folderPath;
    QPushButton *buttonDir;
    QDialogButtonBox *folderDialogButtons;
    QPushButton *browseButton;
    QPushButton *folderDoneButton;

    QCheckBox *showDescriptions;
    QCheckBox *hideFirstDescription;
    QCheckBox *showHiddenFiles;

    QDialogButtonBox *dialogButton;
    QPushButton *doneButton;

    QString trSavePosition1, trSavePosition2, trDir, trNewDir, trDescription, trNumber, trPath, trBrowse, trDone,;
    QString trShowDescriptions1, trShowDescriptions2, trHideFirstDescription1, trHideFirstDescription2;
    QString trPauseOnUnplugged1, trPauseOnUnplugged2, trResumeOnPlugged1, trResumeOnPlugged2;

    UI * parent;

private slots:
    void addDirectory();
    void deleteDirectory(int);
    void editFolder(int);
    void browsePath();
};
#endif //SETTINGSDIALOG_H
