#include "DelegateFolder.h"

void DelegateFolder::paint ( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const
{
    painter->save();

    if (option.state & QStyle::State_Selected)
        QStyledItemDelegate::paint(painter, option, QModelIndex());

    QRect r = option.rect;
    QFont f = painter->font();
    QColor defaultTextColor = QMaemo5Style::standardColor("DefaultTextColor");
    QColor secondaryTextColor = QMaemo5Style::standardColor("SecondaryTextColor");

    f.setPointSize(18);

    f.setBold(false);
    painter->setFont(f);
    painter->setPen(QPen(defaultTextColor));
    QString folderItem = painter->fontMetrics().
            elidedText(index.data(UserRoleFolderItem).toString(), Qt::ElideRight, 740);
    painter->drawText(6, r.top(), 740, 68, Qt::AlignVCenter|Qt::AlignLeft, folderItem);

    painter->restore();
}

QSize DelegateFolder::sizeHint(const QStyleOptionViewItem&, const QModelIndex&) const
{
    return QSize(760, 68);
}

DelegateFolder::~DelegateFolder()
{

}
