#ifndef PLAYER_H
#define PLAYER_H

#include <QtCore>
#include <QtGui>

#include "Engine.h"
#include "UI.h"
#include "Config.h"
#include "DBusService.h"

class Player : public QApplication
{
    Q_OBJECT
public:
    Player(int& argc, char** argv);
    /*
   * Destructor
   */
    ~Player();

    /*
   * The media engine
   */
    Engine* engine;
    /*
   * The ui
   */
    UI* ui;
    Config* config;

    void restoreLastPlayed();

    void restorePlaylist(QString filename="");

    void savePlaylist(QString filename="");

    void openPlaylist_pls(QString filename);


    void restoreConf();

    /*
   * Add a media in the playlist
   */
    void addMedia(QStringList ss);

    /*
   * Save settings
   */
    void saveConf();

    bool getBoolRestoredPlaylist()
    {
        return restoredPlaylist;
    }

    void showApp();
    void playResource(QString uri);

public slots:
    void onQuit();
    void play(int row, short clickAction);
    void stop();
    void next(bool click = false);
    void prev();

private:
    DBusService* dbus;
    QString musicPath;
    QTimer* timerPreviousOrNextClicking;
    QTimer* timerStopClicking;
    bool useAppVol;
    bool previousOrNextClicking;
    bool playIfNoMoreClickActive;
    bool stopClicking;
    bool restoredPlaylist;

private slots:
    void unblockButtons();
    void playIfNoMoreClick();
    void previousOrNextTimeOut();
    void stopTimeOut();

};

#endif
