#include "UrlDialog.h"

UrlDialog::UrlDialog()
{
  #ifdef Q_WS_MAEMO_5
  urlLayout = new QHBoxLayout(this);
  #else
  urlLayout = new QVBoxLayout(this);
  #endif
  
  url = new QLineEdit(this);
  
  urlLayout->addWidget(url);
  
  dialogButtons = new QDialogButtonBox(this);
  dialogButtons->setStandardButtons(QDialogButtonBox::Ok|QDialogButtonBox::Cancel);
  #ifdef Q_WS_MAEMO_5
  dialogButtons->setOrientation(Qt::Vertical);
  #endif
  urlLayout->addWidget(dialogButtons);
  setWindowTitle(tr("Url"));
  
  connect(dialogButtons,SIGNAL(accepted()),this,SLOT(accept()));
  connect(dialogButtons,SIGNAL(rejected()),this,SLOT(reject()));
}

UrlDialog::~UrlDialog()
{
  if(dialogButtons)
    delete dialogButtons;
  if(url)
    delete url;
  if(urlLayout)
    delete urlLayout;
}

QString UrlDialog::getUrl()
{  
  return url->text();  
}

void UrlDialog::setUrl(QString inUrl)
{
  url->setText(inUrl);  
}
