#ifndef PLAYER_H
#define PLAYER_H

#include <QtCore>
#include <QtGui>

#include "Engine.h"
#include "UI.h"
#include "Config.h"

class Player : public QApplication
{
		Q_OBJECT
	public:
		Player(int& argc, char** argv);
		/*
		 * Destructor
		 */
		~Player();

		/*
		 * The media engine
		 */
		Engine* engine;
		/*
		 * The ui
		 */
		UI* ui;
		Config* config;


		void restorePlaylist(QString filename="");
		
		void savePlaylist(QString filename="");
		
		void openPlaylist_pls(QString filename);


		void restoreConf();

		/*
		 * Add a media in the playlist
		 */
		void addMedia(QStringList ss);

		/*
		 * Save settings
		 */
		void saveConf();

		
	public slots:
		void onQuit();
		void play(int row);
		void stop();
		void next();
		void prev();

	private:
		QString musicPath;
};

#endif
