#include "UrlDialog.h"

UrlDialog::UrlDialog()
{
    urlLayout = new QVBoxLayout(this);

    url = new QLineEdit(this);

    urlLayout->addWidget(url);

    dialogButtons = new QDialogButtonBox(this);
    doneButton = new QPushButton(tr("Done"));
    pasteButton = new QPushButton(tr("Paste"));
    dialogButtons->addButton(doneButton, QDialogButtonBox::AcceptRole);
    dialogButtons->addButton(pasteButton, QDialogButtonBox::ActionRole);
    dialogButtons->setOrientation(Qt::Horizontal);
    urlLayout->addWidget(dialogButtons);
    setWindowTitle(tr("Url"));

    connect(dialogButtons, SIGNAL(accepted()), this, SLOT(accept()));
    connect(dialogButtons, SIGNAL(rejected()), this, SLOT(reject()));
    pasteButton->connect(pasteButton, SIGNAL(clicked()), this, SLOT(pasteClipboard()));
}

UrlDialog::~UrlDialog()
{
    if(dialogButtons)
        delete dialogButtons;
    if(url)
        delete url;
    if(urlLayout)
        delete urlLayout;
}

QString UrlDialog::getUrl()
{  
    url->setFocus();
    return url->text();
}

void UrlDialog::setUrl(QString inUrl)
{
    url->setText(inUrl);
}

void UrlDialog::pasteClipboard()
{
    clipboard = QApplication::clipboard();
    url->setText(clipboard->text());
}
