#ifndef UICONTROL2_H
#define UICONTROL2_H

#include <QtGui>

class Player;

class UIControl2 : public QWidget
{
    Q_OBJECT
public:
    UIControl2(Player* parent);
    ~UIControl2();

    void
    setRandom(bool b)
    {
        if (b)
        {
            buttonRandom->setIcon(QIcon("/etc/hildon/theme/mediaplayer/ShufflePressed.png"));
        }
        else
        {
            buttonRandom->setIcon(QIcon("/etc/hildon/theme/mediaplayer/Shuffle.png"));
        }
    }

    void
    setRepeat(bool b)
    {
        if (b)
        {
            buttonRepeat->setIcon(QIcon("/etc/hildon/theme/mediaplayer/RepeatPressed.png"));
        }
        else
        {
            buttonRepeat->setIcon(QIcon("/etc/hildon/theme/mediaplayer/Repeat.png"));
        }
    }

    void buttonClearPlaylist();
    void buttonsToggle();

private:
    QWidget *buttonsMode, *buttonsPL, *buttonsAddOns;
    QPushButton *buttonAddOns, *buttonAutoAddons, *buttonDel, *buttonUp, *buttonDown, *buttonRandom, *buttonRepeat;
    QHBoxLayout *layoutControl2, *layoutControlMode, *layoutControlPL, *layoutControlAddOns;

    Player* parent;

private slots:
    void buttonRandomPressed();
    void buttonRandomChanged();
    void buttonRepeatPressed();
    void buttonRepeatChanged();
    void upItem();
    void buttonUpReleased();
    void buttonUpEnableAutoRepeat();
    void downItem();
    void buttonDownReleased();
    void buttonDownEnableAutoRepeat();
    void delItem();
    void buttonDelReleased();
    void buttonDelEnableAutoRepeat();
    void buttonAutoAddonsChanged();
    void buttonAutoAddonsReleased();
    void buttonAutoAddonsEnableAutoRepeat();
};

#endif // UICONTROL2_H
