#include <iostream>
#include <QtGui>
#include "Player.h"
#include "UI.h"


UI::UI(Player* parent, QString& musicPath, QString& musicName)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    this->parent = parent;

    setupActions();
    setupMenus();
    
    currDir = QDesktopServices::storageLocation(QDesktopServices::HomeLocation) + "/MyDocs";

    //QStyle* style = this->style();

    // Initialize the random
    qsrand(time(NULL));

    infosFrame = new QFrame();
    infosFrame->setFrameShape(QFrame::NoFrame);
    infosFrame->setFixedWidth(300);
    infosFrame->setFixedHeight(130);
    infosArea = new QScrollArea();
    infosArea->setWidgetResizable(true);
    infosArea->setAlignment(Qt::AlignCenter);

    infosSong = new QToolButton();
    infosSong->setFixedHeight(111);
    infosSong->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    infosSong->setStyleSheet("background-color: transparent;");
    infosSong->setText("\n");
    areaW = new QWidget();
    infosAreaLayout=new QVBoxLayout(areaW);
    infosAreaLayout->setAlignment(Qt::AlignHCenter | Qt::AlignTop);
    infosAreaLayout->setMargin(0);
    infosAreaLayout->addSpacing(7);
    infosAreaLayout->addWidget(infosSong);
    infosArea->setWidget(areaW);
    infosFrameLayout = new QHBoxLayout;
    infosFrameLayout->setMargin(0);
    infosFrameLayout->addSpacing(6);
    infosFrameLayout->addWidget(infosArea);
    infosFrameLayout->addSpacing(6);
    infosFrame->setLayout(infosFrameLayout);

    infosSong->setAutoRepeat(true);
    infosSong->setAutoRepeatDelay(1000);
    infosSong->setAutoRepeatInterval(1000);

    connect(infosSong, SIGNAL(pressed()), SLOT(infosSongPressed()));
    connect(infosSong, SIGNAL(released()), SLOT(infosSongReleased()));
    connect(infosSong, SIGNAL(clicked()), SLOT(infosSongClicked()));

    // Controls
    controls = new UIControl(parent);
    // Playlist
    playlist = new UIPlaylist(parent);
    playlist->setFixedWidth(389);
    // Folder
    library = new UILibrary(parent,musicPath, musicName);
    // Controls2
    controls2 = new UIControl2(parent);
    // Controls3
    controls3 = new UIControl3(parent);
    // SongAddOns
    songAddOns = new QWidget();
    songAddOns->setFixedWidth(389);
    songAddOnsLayout = new QVBoxLayout();
    songAddOnsLayout->setAlignment(Qt::AlignCenter);
    songAddOnsAlbum = new QLabel();
    songAddOnsAlbum->setPixmap(QPixmap("/opt/necroplayer2/icons/295x295/default_album.png").
                                 scaled(295, 295, Qt::KeepAspectRatio));
    songAddOnsLayout->addWidget(songAddOnsAlbum);
    songAddOns->setLayout(songAddOnsLayout);
    songAddOns->setHidden(true);

    // Layouts
    mainLayout = new QHBoxLayout;
    playerLayout =new QHBoxLayout;
    ctrlLayout = new QVBoxLayout;

    mainLayout->setMargin(5);
    playerLayout->setMargin(0);
    ctrlLayout->setMargin(0);

    inf_seek=new QVBoxLayout;
    inf_seek->setAlignment(Qt::AlignCenter);
    inf_seek->addSpacing(10);
    inf_seek->addWidget(infosFrame);
    inf_seek->addLayout(parent->engine->getSeekLayout());

    inf_seek_volume=new QHBoxLayout;
    inf_seek_volume->addSpacing(10);
    inf_seek_volume->addLayout(inf_seek);
    inf_seek_volume->addLayout(parent->engine->getVolLayout());

    ctrlLayout->addLayout(inf_seek_volume);
    ctrlLayout->addWidget(controls);

    playerLayout->addLayout(ctrlLayout);
    playerLayout->addWidget(playlist);
    playerLayout->addWidget(songAddOns);

    player =new QWidget;
    player->setLayout(playerLayout);

    // Tab
    tab = new QTabWidget;
    tab->addTab(player, tr("Playing"));
    tab->addTab(library, tr("Media"));

    tab->setCornerWidget(controls2);

    connect(tab, SIGNAL(currentChanged(int)), this,SLOT(tabChanged()));

    mainLayout->addWidget(tab);

    //mainLayout->setSpacing(0);

    // Accept drag'n'drop
    setAcceptDrops(false);

    mainW = new QWidget();
    mainW->setLayout(mainLayout);
    setCentralWidget(mainW);
    
    simpleview = new SimpleView(this);
    simpleview->setParent(this);
    simpleview->setWindowFlags(Qt::Window);
    simpleview->setAttribute(Qt::WA_Maemo5StackedWindow);

    settingsdialog = new SettingsDialog(this);
    settingsdialog->setParent(this);
    settingsdialog->setWindowFlags(Qt::Window);
    settingsdialog->setAttribute(Qt::WA_Maemo5StackedWindow);

    urldialog = new UrlDialog();
    urldialog->setParent(this);
    urldialog->setWindowFlags(Qt::Dialog);
    connect(urldialog, SIGNAL(accepted()), this, SLOT(urlDialogAccepted()));

    coverdialog = new CoverDialog(parent);
    coverdialog->setParent(this);
    coverdialog->setWindowFlags(Qt::Dialog);

    trApp2 = tr("further developed by");
    trIandI = tr("based on and inspired by");
    trPLFiles = tr("Playlist files");

    setWindowTitle("NecroPlayer2");
    show();
}
UI::~UI()
{
    //qDebug()<<"UI destructor";
    
    if (settingsdialog)
        delete settingsdialog;
    if (infosSong)
        delete infosSong;
    if (infosAreaLayout)
        delete infosAreaLayout;
    if (infosArea)
        delete infosArea;
    if (controls)
        delete controls; controls = NULL;
    if (library)
        delete library; library = NULL;
    if (inf_seek)
        delete inf_seek;
    if (inf_seek_volume)
        delete inf_seek_volume;
    if (ctrlLayout)
        delete ctrlLayout;
    if (playlist)
        delete playlist; playlist = NULL;
    if (playerLayout)
        delete playerLayout;
    if (player)
        delete player;
    if (tab)
        delete tab;
    if (mainLayout)
        delete mainLayout;
    if (mainW)
        delete mainW;
}

void
UI::infosSongPressed()
{
    infosFrame->setFrameShape(QFrame::Panel);
}

void
UI::infosSongReleased()
{
    infosFrame->setFrameShape(QFrame::NoFrame);
    if (!infosSong->autoRepeat())
        QMetaObject::invokeMethod(this, "infosSongEnableAutoRepeat", Qt::QueuedConnection);
}

void
UI::infosSongEnableAutoRepeat()
{
    infosSong->setAutoRepeat(true);
}

void
UI::infosSongClicked()
{
    if (infosSong->isDown())
    {
        infosSong->setAutoRepeat(false);
        simpleview->showNormal();
        QTimer::singleShot(1, simpleview, SLOT(showFullScreen()));
    }
    else if (infosSong->autoRepeat())
    {
        controls2->buttonsToggle();
        playlist->setHidden(!playlist->isHidden());
        songAddOns->setHidden(!songAddOns->isHidden());
    }
}

void
UI::showSongAddOns()
{
    if (songAddOns->isHidden())
    {
        controls2->buttonsToggle();
        playlist->setHidden(true);
        songAddOns->setHidden(false);
    }
}

void
UI::hideSongAddOns()
{
    if (playlist->isHidden())
    {
        controls2->buttonsToggle();
        playlist->setHidden(false);
        songAddOns->setHidden(true);
    }
}

void
UI::tabChanged()
{
    if (tab->currentIndex() == 0)
    {
        tab->setCornerWidget(controls2);
        controls2->show();
    }
    if (tab->currentIndex() == 1)
    {
        tab->setCornerWidget(controls3);
        controls3->show();
    }
}

void
UI::folderBackToRoot()
{
    library->folderBackToRoot();
}

void
UI::folderBack()
{
    library->folderBack();
}

void
UI::slotAddFolder(bool autoplay)
{
    library->slotAddFolder(autoplay, false);
}

void
UI::slotReplFolder(bool autoplay)
{
    library->slotReplFolder(autoplay);
}

void
UI::clearPlaylist()
{
    playlist->clearPlaylist(); 
}

void
UI::setBold(unsigned int row, bool b)
{
    playlist->setBold(row, b);
}

void
UI::playlistAdd(QStringList ss)
{
    parent->engine->addMedia(ss);
    parent->engine->startMetaUpdater();
}

void
UI::addItem(QString s)
{
    playlist->addItem(s);
}

void UI::changeItem(QString title, QString artist, QString totalTime, int row, short status)
{
    playlist->changeItem(title, artist, totalTime, row, status);
}

void
UI::upItem()
{
    playlist->upItem();
}

void
UI::topItem()
{
    playlist->topItem();
}

void
UI::downItem()
{
    playlist->downItem();
}

void
UI::bottomItem()
{
    playlist->bottomItem();
}

void
UI::delItem()
{
    playlist->delItem();
}

void
UI::buttonClearPlaylist()
{
    playlist->buttonClearPlaylist();
}

void
UI::setInfos(QString s, QString t)
{
    infosSong->setText(s);
    simpleview->infosSongSetText(s);

    if (t == "stream")
    {
        QPixmap pic("/opt/necroplayer2/icons/295x295/default_stream.png");
        songAddOnsAlbum->setPixmap(pic.scaled(295, 295, Qt::KeepAspectRatio));
    }
    else if (!t.isEmpty())
    {
        QPixmap pic(t);
        songAddOnsAlbum->setPixmap(pic.scaled(331, 331, Qt::KeepAspectRatio));
    }
    else
    {
        QPixmap pic("/opt/necroplayer2/icons/295x295/default_album.png");
        songAddOnsAlbum->setPixmap(pic.scaled(295, 295, Qt::KeepAspectRatio));
    }
}

void UI::setupActions()
{
    loadPlaylist =  new QAction(tr("Open Playlist"),this);
    connect(loadPlaylist, SIGNAL(triggered()), this, SLOT(loadPlaylistDialog()));

    savePlaylist =  new QAction(tr("Save Playlist"),this);
    connect(savePlaylist, SIGNAL(triggered()), this, SLOT(savePlaylistDialog()));

    openUrl = new QAction(tr("Open Url"),this);
    connect(openUrl, SIGNAL(triggered()), this, SLOT(openUrlDialog()));

    settingsAction = new QAction(tr("Settings"),this);
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(settingsDialogOpen()));

    aboutAction = new QAction(tr("Info"),this);
    connect(aboutAction, SIGNAL(triggered()), this, SLOT(aboutDialogOpen()));
}

void UI::setupMenus()
{
    menu = menuBar();
    menu->addAction(loadPlaylist);
    menu->addAction(savePlaylist);
    menu->addAction(openUrl);
    menu->addAction(settingsAction);
    menu->addAction(aboutAction);
}

void UI::aboutDialogOpen()
{
    aboutDialog = new QDialog(this);
    aboutDialog->setWindowTitle("Info");
    layoutAbout = new QVBoxLayout;
    layoutAbout->setMargin(32);
    layoutAbout->setSpacing(16);
    layoutAbout->setAlignment(Qt::AlignCenter);

    logo = new QLabel("<center><img src=/usr/share/icons/hicolor/64x64/"
                      "apps/necroplayer2.png width=64 height=64></center>");
    textApp = new QLabel("<center><big><b>NecroPlayer2&nbsp;&nbsp;"VERSION"</b></big>\n</center>");
    texttrApp2 = new QLabel("<center>" + trIandI + " NecroPlayer 0.3.4\n</center>");
    texttrIandI = new QLabel("<center>" + trApp2 + " Marc Poepperl (rasmarc)\n</center>");

    layoutAbout->addWidget(logo);
    layoutAbout->addWidget(textApp);
    layoutAbout->addWidget(texttrApp2);
    layoutAbout->addWidget(texttrIandI);
    aboutDialog->setLayout(layoutAbout);
    aboutDialog->show();
}

void UI::settingsDialogOpen()
{
    settingsdialog->setConfig(parent->config);
    settingsdialog->show();

}

int UI::musicFoldersSize()
{
    return parent->config->musicFolders.size();
}

void UI::settingsDialogAccepted()
{
//    bool tmpDefaultPlayer = parent->config->defaultPlayer;
    bool tmpUseTags = parent->config->useTags;
    bool tmpUpdateOnPlay = parent->config->updateOnPlay;

    settingsdialog->getConfig(parent->config);

    playlist->setTransparentBackground();
    library->musicPathDir0SetText();

    if (tmpUseTags != parent->config->useTags || tmpUpdateOnPlay != parent->config->updateOnPlay)
    {
        parent->engine->startMetaUpdater(true);
    }

    if (parent->config->musicIndex < parent->config->musicFolders.size())
    {
        if (library->getMusicName() !=
                parent->config->musicDescriptions.at(parent->config->musicIndex) ||
                library->getMusicPath() !=
                parent->config->musicFolders.at(parent->config->musicIndex))
        {
            library->refreshWithNewMusicPath(parent->config->musicIndex);
        }
    }
    else
    {
        parent->config->musicIndex = 0;
        library->refreshWithNewMusicPath(0);
    }

//    if (tmpFolder != parent->config->musicFolder)
//    {
//        library->refreshWithNewMusicPath(0);
//    }

//    if (tmpDefaultPlayer != parent->config->defaultPlayer)
//    {
//        if (tmpDefaultPlayer)
//        {
//            system("sudo necroplayer2.sh default_player_off");
//        }
//        else
//        {
//            system("sudo necroplayer2.sh default_player_on");
//        }
//    }
    parent->saveConf();
    settingsdialog->hide();

}

void UI::loadPlaylistDialog()
{
    QString tmpfile;

    tmpfile = QFileDialog::getOpenFileName(this, "Open Playlist", currDir, "(*.m3u *.M3U *.pls *.PLS)");

    if(!tmpfile.isNull())
    {
        if(tmpfile.endsWith(".pls",Qt::CaseInsensitive))
        {
            parent->openPlaylist_pls(tmpfile);
        }
        else
        {
            parent->restorePlaylist(tmpfile);
        }

        parent->engine->startMetaUpdater();

        QFileInfo tmpinfo(tmpfile);
        currDir=tmpinfo.dir().absolutePath();
    }
}

void UI::savePlaylistDialog()
{
    QString tmpfile;

    tmpfile=QFileDialog::getSaveFileName(this, "Save Playlist", currDir,
                                         trPLFiles + "(*.m3u *.M3U)");

    if((!tmpfile.isNull())&&(!tmpfile.isEmpty()))
    {
        if(!tmpfile.endsWith(".m3u",Qt::CaseInsensitive))
            tmpfile.append(".m3u");

        parent->savePlaylist(tmpfile);
        QFileInfo tmpinfo(tmpfile);
        currDir=tmpinfo.dir().absolutePath();
    }
}

void UI::openUrlDialog()
{
    urldialog->setUrl("");
    urldialog->show();
}

void UI::urlDialogAccepted()
{
    QString tmpstr = urldialog->getUrl();
    if (!tmpstr.isNull() && !tmpstr.isEmpty())
    {
        QStringList tmplist;
        tmplist.append(tmpstr);
        playlistAdd(tmplist);
    }
}

void UI::openCoverDialog(int row)
{
    coverdialog->getCover(row);
    coverdialog->show();
}

QHBoxLayout*
UI::getSeekSimpleLayout()
{
    return parent->engine->getSeekSimpleLayout();
}
