#include "SimpleView.h"
#include "UI.h"
#include "QDBusConnection"
#include "QDBusReply"

SimpleView::SimpleView(UI *parent)
{
    this->parent = parent;

    QDBusConnection::systemBus().connect("com.nokia.FMTx",
                                         "/com/nokia/fmtx/default",
                                         "com.nokia.FMTx.Device",
                                         "Changed",
                                         this, SLOT(onFMChanged()));

    setStyleSheet("background: black;");

    simpleLayout = new QGridLayout(this);

    infosFrame = new QFrame();
    infosFrame->setFrameShape(QFrame::NoFrame);
    infosFrame->setFixedWidth(652);
    infosFrame->setFixedHeight(180);
    infosSong = new QToolButton();
    infosSong->setFixedHeight(160);
    infosSong->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    infosSong->setStyleSheet("background-color: transparent;");
    QFont f(font());
    f.setPointSize(36);
    infosSong->setFont(f);
    infosSong->setText("\n");
    infosFrameLayout = new QHBoxLayout;
    infosFrameLayout->setAlignment(Qt::AlignCenter);
    infosFrameLayout->setMargin(0);
    infosFrameLayout->addWidget(infosSong);
    infosFrame->setLayout(infosFrameLayout);

    infosSong->setAutoRepeat(true);
    infosSong->setAutoRepeatDelay(1000);
    infosSong->setAutoRepeatInterval(1000);

    buttonPlay = new QPushButton();
    buttonPlay->setIcon(QIcon(QPixmap("/opt/necroplayer2/icons/64x64/play.png").
                              scaled(80, 80, Qt::KeepAspectRatio, Qt::SmoothTransformation)));
    buttonStop = new QPushButton();
    buttonStop->setIcon(QIcon(QPixmap("/opt/necroplayer2/icons/64x64/stop.png").
                              scaled(80, 80, Qt::KeepAspectRatio, Qt::SmoothTransformation)));
    buttonNext = new QPushButton();
    buttonNext->setIcon(QIcon(QPixmap("/opt/necroplayer2/icons/64x64/next.png").
                              scaled(80, 80, Qt::KeepAspectRatio, Qt::SmoothTransformation)));
    buttonPrev = new QPushButton();
    buttonPrev->setIcon(QIcon(QPixmap("/opt/necroplayer2/icons/64x64/previous.png").
                              scaled(80, 80, Qt::KeepAspectRatio, Qt::SmoothTransformation)));

    buttonFM = new QPushButton(QIcon("/opt/necroplayer2/icons/40x40/fm_transmitter.png"),"");

    buttonFM->setAutoRepeat(true);
    buttonFM->setAutoRepeatDelay(1000);
    buttonFM->setAutoRepeatInterval(1000);

    buttonFM->setCheckable(true);
    seekFMLayout = new QHBoxLayout;
    seekFMLayout->setMargin(0);
    seekFMLayout->addLayout(parent->getSeekSimpleLayout(), Qt::AlignBottom);
    seekFMLayout->addSpacing(16);
    seekFMLayout->addWidget(buttonFM, Qt::AlignBottom);

    buttonPlay->setFixedSize(184, 146);
    buttonStop->setFixedSize(184, 146);
    buttonNext->setFixedSize(184, 146);
    buttonPrev->setFixedSize(184, 146);
    buttonFM->setFixedSize(146, 56);

    buttonPlay->setIconSize(QSize(80, 80));
    buttonStop->setIconSize(QSize(80, 80));
    buttonNext->setIconSize(QSize(80, 80));
    buttonPrev->setIconSize(QSize(80, 80));
    buttonFM->setIconSize(QSize(40, 40));

    buttonPlay->setFlat(true);
    buttonStop->setFlat(true);
    buttonNext->setFlat(true);
    buttonPrev->setFlat(true);
    buttonFM->setFlat(true);

    buttonPlay->setStyleSheet("QPushButton {border-radius: 10px;}"
                              "QPushButton:pressed {background-color: rgb(0,127,0);}");
    buttonStop->setStyleSheet("QPushButton {border-radius: 10px;}"
                              "QPushButton:pressed {background-color: rgb(127,0,0);}");
    buttonNext->setStyleSheet("QPushButton {border-radius: 10px;}"
                              "QPushButton:pressed {background-color: rgb(232,172,0);}");
    buttonPrev->setStyleSheet("QPushButton {border-radius: 10px;}"
                              "QPushButton:pressed {background-color: rgb(232,172,0);}");

    buttonFM->setStyleSheet("QPushButton {background-color: rgb(28, 28, 28); border-radius: 5px;}"
                            "QPushButton:pressed {background-color: rgb(96, 96, 96);}"
                            "QPushButton:checked {background-color: rgb(96, 96, 96);}");

    layoutControl= new QHBoxLayout;
    layoutControl->setMargin(4);
    layoutControl->addWidget(buttonPrev);
    layoutControl->addWidget(buttonPlay);
    layoutControl->addWidget(buttonStop);
    layoutControl->addWidget(buttonNext);

    connect(infosSong, SIGNAL(pressed()), SLOT(infosSongPressed()));
    connect(infosSong, SIGNAL(released()), SLOT(infosSongReleased()));
    connect(infosSong, SIGNAL(clicked()), SLOT(simpleViewHide()));

    connect(buttonFM, SIGNAL(released()), SLOT(buttonFMReleased()));
    connect(buttonFM, SIGNAL(clicked()), SLOT(buttonFMClicked()));

    connect(buttonPlay, SIGNAL(clicked()), SLOT(play()));
    connect(buttonStop, SIGNAL(clicked()), SLOT(stop()));
    connect(buttonNext, SIGNAL(clicked()), SLOT(next()));
    connect(buttonPrev, SIGNAL(clicked()), SLOT(prev()));

    simpleLayout->setColumnMinimumWidth(0, 40);
    simpleLayout->setColumnMinimumWidth(2, 40);

    simpleLayout->setRowMinimumHeight(0, 22);
    simpleLayout->addWidget(infosFrame, 1, 1, Qt::AlignHCenter | Qt::AlignTop);
    simpleLayout->addLayout(seekFMLayout, 2, 1);
    simpleLayout->setRowMinimumHeight(3, 6);
    simpleLayout->addLayout(layoutControl, 4, 0, 1, 3);
    simpleLayout->setRowMinimumHeight(5, 2);

    simpleviewfm = new SimpleViewFM(parent);
    simpleviewfm->setParent(this);
    simpleviewfm->setWindowFlags(Qt::Window);
    simpleviewfm->setAttribute(Qt::WA_Maemo5StackedWindow);

    onFMChanged();
}

SimpleView::~SimpleView()
{

}

void
SimpleView::infosSongSetText(QString s)
{
    QFont f(font());
    f.setPointSize(34);
    QFontMetrics fm(f);

    if (s.contains("\n"))
    {
        infosSong->setText(fm.elidedText(s.split("\n")[0], Qt::ElideRight, 630) + "\n" +
                           fm.elidedText(s.split("\n")[1], Qt::ElideRight, 630));
    }
    else
    {
        infosSong->setText(fm.elidedText(s, Qt::ElideRight, 630));
    }
}

void
SimpleView::infosSongPressed()
{
    infosFrame->setFrameShape(QFrame::Panel);
}

void
SimpleView::infosSongReleased()
{
    infosFrame->setFrameShape(QFrame::NoFrame);
    if (!infosSong->autoRepeat())
        QMetaObject::invokeMethod(this, "infosSongEnableAutoRepeat", Qt::QueuedConnection);
}

void
SimpleView::infosSongEnableAutoRepeat()
{
    infosSong->setAutoRepeat(true);
}

void
SimpleView::simpleViewHide()
{
    if (infosSong->isDown())
    {
        infosSong->setAutoRepeat(false);
        hide();
    }
    else if (infosSong->autoRepeat())
    {
    }
}

void
SimpleView::buttonFMReleased()
{
    if (!buttonFM->autoRepeat())
        QMetaObject::invokeMethod(this, "buttonFMEnableAutoRepeat", Qt::QueuedConnection);
}

void
SimpleView::buttonFMEnableAutoRepeat()
{
    buttonFM->setAutoRepeat(true);
}

void
SimpleView::buttonFMClicked()
{
    if (buttonFM->isDown())
    {
        buttonFM->setAutoRepeat(false);
        simpleviewfm->showNormal();
        QTimer::singleShot(1, simpleviewfm, SLOT(showFullScreen()));
    }
    else if (buttonFM->autoRepeat())
    {
        buttonFM->setChecked(!buttonFM->isChecked());
        if (getFMStatus())
        {
            system("/usr/bin/fmtx_client -p 0");
        }
        else
        {
            system("/usr/bin/fmtx_client -p 1");
        }
    }
}

void
SimpleView::onFMChanged()
{
    buttonFM->setChecked(getFMStatus());

    QDBusMessage msg = QDBusMessage::createMethodCall("com.nokia.FMTx",
                                                    "/com/nokia/fmtx/default",
                                                    "org.freedesktop.DBus.Properties", "Get");
    msg.setArguments(QList<QVariant>() << "com.nokia.FMTx.Device" << "frequency");

    simpleviewfm->setFMFreq(QDBusReply<QDBusVariant>(QDBusConnection::systemBus().call(msg)).
                            value().variant().toInt());

    simpleviewfm->getFMFreqLabel().setText
            (QString::number(QDBusReply<QDBusVariant>(QDBusConnection::systemBus().call(msg)).
                             value().variant().toDouble() / 1000, 'f', 1));
}

bool
SimpleView::getFMStatus()
{
//    QProcess process;
//    process.start("/usr/bin/fmtx_client");
//    process.waitForFinished(-1);

//    if (process.readAllStandardOutput().contains("state=enabled"))
//    {
//        return true;
//    }

    QDBusMessage msg = QDBusMessage::createMethodCall("com.nokia.FMTx",
                                                    "/com/nokia/fmtx/default",
                                                    "org.freedesktop.DBus.Properties", "Get");
    msg.setArguments(QList<QVariant>() << "com.nokia.FMTx.Device" << "state");

    if (QDBusReply<QDBusVariant>(QDBusConnection::systemBus().call(msg)).value().variant().toString() == "enabled")
    {
        return true;
    }

    return false;
}

void
SimpleView::blockButtons()
{
    buttonPrev->blockSignals(true);
    buttonPlay->blockSignals(true);
    buttonStop->blockSignals(true);
    buttonNext->blockSignals(true);
}

void
SimpleView::unblockButtons()
{
    buttonPrev->blockSignals(false);
    buttonPlay->blockSignals(false);
    buttonStop->blockSignals(false);
    buttonNext->blockSignals(false);
}

void
SimpleView::play()
{
    parent->getControls().play();
}

void
SimpleView::stop()
{
    parent->getControls().stop();
}

void
SimpleView::next()
{
    parent->getControls().next();
}

void
SimpleView::prev()
{
    parent->getControls().prev();
}

void
SimpleView::setPlayIcon(Phonon::State state)
{
    switch (state)
    {
    case Phonon::PlayingState:
        buttonPlay->setIcon(QIcon(QPixmap("/opt/necroplayer2/icons/64x64/play.png").
                                  scaled(80, 80, Qt::KeepAspectRatio, Qt::SmoothTransformation)));
        break;
    case Phonon::PausedState:
        buttonPlay->setIcon(QIcon(QPixmap("/opt/necroplayer2/icons/64x64/pause.png").
                                  scaled(80, 80, Qt::KeepAspectRatio, Qt::SmoothTransformation)));
        break;
    default:
        break;
    }
}
