#include "DelegatePlaylist.h"

void DelegatePlaylist::paint ( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const
{
    painter->save();

    if (option.state & QStyle::State_Selected)
        QStyledItemDelegate::paint(painter, option, QModelIndex());

    QRect r = option.rect;
    QFont f = painter->font();
    QColor defaultTextColor = QMaemo5Style::standardColor("DefaultTextColor");
    QColor secondaryTextColor = QMaemo5Style::standardColor("SecondaryTextColor");
    QColor activeTextColor(255, 255, 176);
    QColor secondaryActiveTextColor(219, 219, 152);

    f.setPointSize(18);

    f.setBold(false);
    painter->setFont(f);
    painter->setPen(QPen(defaultTextColor));
    QString titleDefault = painter->fontMetrics().
            elidedText(index.data(UserRoleTitleDefault).toString(), Qt::ElideRight, 355);
    painter->drawText(2, r.top()+4, 358, 36, Qt::AlignTop|Qt::AlignLeft, titleDefault);

    painter->setPen(QPen(Qt::red));
    QString titleDisabled = painter->fontMetrics().
            elidedText(index.data(UserRoleTitleDisabled).toString(), Qt::ElideRight, 355);
    painter->drawText(2, r.top()+4, 358, 36, Qt::AlignTop|Qt::AlignLeft, titleDisabled);

    f.setBold(true);
    painter->setFont(f);
    painter->setPen(QPen(activeTextColor));
    QString titleActive = painter->fontMetrics().
            elidedText(index.data(UserRoleTitleActive).toString(), Qt::ElideRight, 355);
    painter->drawText(2, r.top()+4, 358, 36, Qt::AlignTop|Qt::AlignLeft, titleActive);

    painter->setPen(QPen(Qt::red));
    QString titleDisabledActive = painter->fontMetrics().
            elidedText(index.data(UserRoleTitleDisabledActive).toString(), Qt::ElideRight, 355);
    painter->drawText(2, r.top()+4, 358, 36, Qt::AlignTop|Qt::AlignLeft, titleDisabledActive);

    f.setPointSize(14);

    f.setBold(false);
    painter->setFont(f);
    painter->setPen(QPen(secondaryTextColor));
    QString artistDefault = painter->fontMetrics().
            elidedText(index.data(UserRoleArtistDefault).toString(), Qt::ElideRight, 270);
    painter->drawText(2, r.bottom() - 29, 270, 28, Qt::AlignTop|Qt::AlignLeft, artistDefault);
    QString totalTimeDefault = index.data(UserRoleTotalTimeDefault).toString();
    painter->drawText(278, r.bottom() - 29, 80, 28, Qt::AlignTop|Qt::AlignRight, totalTimeDefault);

    f.setBold(true);
    painter->setFont(f);
    painter->setPen(QPen(secondaryActiveTextColor));
    QString artistActive = painter->fontMetrics().
            elidedText(index.data(UserRoleArtistActive).toString(), Qt::ElideRight, 270);
    painter->drawText(2, r.bottom() - 29, 270, 28, Qt::AlignTop|Qt::AlignLeft, artistActive);
    QString totalTimeActive = index.data(UserRoleTotalTimeActive).toString();
    painter->drawText(278, r.bottom() - 29, 80, 28, Qt::AlignTop|Qt::AlignRight, totalTimeActive);

    painter->restore();
}

QSize DelegatePlaylist::sizeHint(const QStyleOptionViewItem&, const QModelIndex&) const
{
    return QSize(365, 68);
}

DelegatePlaylist::~DelegatePlaylist()
{

}
