#include "Config.h"

Config::Config()
{
    //default settings:
//    defaultPlayer=false;
    autoaddons=true;
    random=false;
    repeat=false;
    pauseOnUnplugged=true;
    resumeOnPlugged=true;
    phoneButtonFn=0;
    volume=1.0;
    useSysVol=true;
    useTags=true;
    updateOnPlay=false;
    savePlaylistOnQuit=true;
    savePosition=false;
    position=0;
    lastPlayed=0;
    transparentPlaylist=false;
    musicFolders.append(QDesktopServices::storageLocation(QDesktopServices::MusicLocation));
    musicDescriptions.append(QString(QObject::tr("Music")));
    musicIndex = 0;
    showDescriptions = true;
    hideFirstDescription = true;
    showHidden=false;

    //config Directory
    configDir.setPath(QDir::homePath() + "/.config/necroplayer2");
    if (!configDir.exists())
        configDir.mkdir(QDir::homePath() + "/.config/necroplayer2");

    //ID's
//    defaultPlayerID="DefaultPlayer = ";
    autoaddonsID="AutoAddOns = ";
    randomID="Random = ";
    repeatID="Repeat = ";
    pauseOnUnpluggedID="PauseOnUnplugged = ";
    resumeOnPluggedID="ResumeOnPlugged = ";
    phoneButtonFnID="PhoneButtonFn = ";
    volumeID="Volume = ";
    useSysVolID="UseSystemVolume = ";
    useTagsID="UseTags = ";
    updateOnPlayID="UpdateOnPlay = ";
    lastPlayedID="LastPlayed = ";
    savePlaylistOnQuitID="SavePlaylist = ";
    savePositionID="SavePosition = ";
    positionID="Position = ";
    transparentPlaylistID="TransparentPlaylist = ";
    musicFoldersID="MusicFolders = ";
    musicDescriptionsID="MusicDescriptions = ";
    musicIndexID="MusicIndex = ";
    showDescriptionsID="ShowDescriptions = ";
    hideFirstDescriptionID="HideFirstDescription = ";
    showHiddenID="ShowHidden = ";
}
void Config::save()
{

    QFile file(configDir.path() + "/necroplayer2rc");
    QTextStream out(&file);
    if (file.open(QIODevice::WriteOnly | QIODevice::Text))
    {

        out<<"#UI settings:\n";

//        out<<defaultPlayerID;
//        if (defaultPlayer)
//            out << "true" <<"\n";
//        else
//            out << "false" <<"\n";

        out<<autoaddonsID;
        if (autoaddons)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<"#Play:\n";

        out<<randomID;
        if(random)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<repeatID;
        if(repeat)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<pauseOnUnpluggedID;
        if(pauseOnUnplugged)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<resumeOnPluggedID;
        if(resumeOnPlugged)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<phoneButtonFnID<<phoneButtonFn<<"\n";

        out<<volumeID<<volume<<"\n";

        out<<"#Player settings:\n";

        out<<useSysVolID;
        if(useSysVol)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<useTagsID;
        if(useTags)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<updateOnPlayID;
        if(updateOnPlay)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<lastPlayedID<<lastPlayed<<"\n";

        out<<savePositionID;
        if(savePosition)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<positionID<<position<<"\n";

        out<<transparentPlaylistID;
        if(transparentPlaylist)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<"#FileBrowser:\n";

        out <<musicFoldersID<<musicFolders.join("|")<<"\n";
        out <<musicDescriptionsID<<musicDescriptions.join("|")<<"\n";
        out <<musicIndexID<<musicIndex<<"\n";

        out<<showDescriptionsID;
        if(showDescriptions)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<hideFirstDescriptionID;
        if(hideFirstDescription)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        out<<showHiddenID;
        if(showHidden)
            out << "true" <<"\n";
        else
            out << "false" <<"\n";

        file.close();

    }

}
void Config::read()
{
    QFile file(configDir.path() + "/necroplayer2rc");
    QTextStream in(&file);
    if (file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        //QString line;// = in.readLine();
        for (QString line=in.readLine();!line.isNull();line=in.readLine())
        {
            if(line.startsWith("#"))
                continue;
            //qDebug()<<line;

//            if(line.startsWith(defaultPlayerID))
//            {
//                line.remove(defaultPlayerID);
//                if (line=="true")
//                    defaultPlayer=true;
//                else
//                    defaultPlayer=false;
//                continue;
//            }

            if(line.startsWith(autoaddonsID))
            {
                line.remove(autoaddonsID);
                if (line=="true")
                    autoaddons=true;
                else
                    autoaddons=false;
                continue;
            }

            if(line.startsWith(randomID))
            {
                line.remove(randomID);
                if (line=="true")
                    random=true;
                else
                    random=false;
                continue;
            }

            if(line.startsWith(repeatID))
            {
                line.remove(repeatID);
                if (line=="true")
                    repeat=true;
                else
                    repeat=false;
                continue;
            }

            if(line.startsWith(pauseOnUnpluggedID))
            {
                line.remove(pauseOnUnpluggedID);
                if (line=="true")
                    pauseOnUnplugged=true;
                else
                    pauseOnUnplugged=false;
                continue;
            }

            if(line.startsWith(resumeOnPluggedID))
            {
                line.remove(resumeOnPluggedID);
                if (line=="true")
                    resumeOnPlugged=true;
                else
                    resumeOnPlugged=false;
                continue;
            }

            if(line.startsWith(phoneButtonFnID))
            {
                line.remove(phoneButtonFnID);
                phoneButtonFn=line.toUShort();
                continue;
            }

            if(line.startsWith(volumeID))
            {
                line.remove(volumeID);
                volume=(line.toFloat());
                continue;
            }

            if(line.startsWith(useSysVolID))
            {
                line.remove(useSysVolID);
                if (line=="true")
                    useSysVol=true;
                else
                    useSysVol=false;
                continue;
            }

            if(line.startsWith(useTagsID))
            {
                line.remove(useTagsID);
                if (line=="true")
                    useTags=true;
                else
                    useTags=false;
                continue;
            }

            if(line.startsWith(updateOnPlayID))
            {
                line.remove(updateOnPlayID);
                if (line=="true")
                    updateOnPlay=true;
                else
                    updateOnPlay=false;
                continue;
            }

            if(line.startsWith(lastPlayedID))
            {
                line.remove(lastPlayedID);
                lastPlayed=line.toInt();
                continue;
            }

            if(line.startsWith(savePositionID))
            {
                line.remove(savePositionID);
                if (line=="true")
                    savePosition=true;
                else
                    savePosition=false;
                continue;
            }

            if(line.startsWith(positionID))
            {
                line.remove(positionID);
                position=line.toLongLong();
                continue;
            }

            if(line.startsWith(transparentPlaylistID))
            {
                line.remove(transparentPlaylistID);
                if (line=="true")
                    transparentPlaylist=true;
                else
                    transparentPlaylist=false;
                continue;
            }


            //       if(line.startsWith(savePlaylistOnQuitID))
            //       {
            // 	line.remove(savePlaylistOnQuitID);
            // 	if (line=="true")
            // 	  savePlaylistOnQuit=true;
            // 	else
            // 	  savePlaylistOnQuit=false;
            // 	continue;
            //       }

            if(line.startsWith(musicFoldersID))
            {
                line.remove(musicFoldersID);
                musicFolders = line.split("|");
                continue;
            }

            if(line.startsWith(musicDescriptionsID))
            {
                line.remove(musicDescriptionsID);
                musicDescriptions = line.split("|");
                continue;
            }

            if(line.startsWith(musicIndexID))
            {
                line.remove(musicIndexID);
                musicIndex = line.toInt();
                continue;
            }

            if(line.startsWith(showDescriptionsID))
            {
                line.remove(showDescriptionsID);
                if (line=="true")
                    showDescriptions=true;
                else
                    showDescriptions=false;
                continue;
            }

            if(line.startsWith(hideFirstDescriptionID))
            {
                line.remove(hideFirstDescriptionID);
                if (line=="true")
                    hideFirstDescription=true;
                else
                    hideFirstDescription=false;
                continue;
            }

            if(line.startsWith(showHiddenID))
            {
                line.remove(showHiddenID);
                if (line=="true")
                    showHidden=true;
                else
                    showHidden=false;
                continue;
            }
        }
        file.close();
    }

}
