#ifndef UI_H
#define UI_H

#include <QtGui>

#include "UILibrary.h"
#include "UIPlaylist.h"
#include "UIControl.h"
#include "UIControl2.h"
#include "UIControl3.h"
#include "SimpleView.h"
#include "SettingsDialog.h"
#include "UrlDialog.h"
#include "CoverDialog.h"

class Player;

class UI : public QMainWindow
{
    Q_OBJECT
public:
    UI(Player* parent, QString& musicPath, QString& musicName);
    ~UI();

    QVBoxLayout *ctrlLayout;
    void folderBackToRoot();
    void folderBack();
    void slotAddFolder(bool autoplay);
    void slotReplFolder(bool autoplay);
    void showSongAddOns();
    void hideSongAddOns();
    void playlistAdd(QStringList ss);
    void clearPlaylist();
    void addItem(QString s);
    void changeItem(QString title, QString artist, QString totalTime, int row, short status = 0);
    void setInfos(QString s, QString t);
    void upItem();
    void topItem();
    void downItem();
    void bottomItem();
    void delItem();
    void buttonClearPlaylist();
    void openCoverDialog(int row);
    void setBold(unsigned int row, bool b);

    int musicFoldersSize();

    int playlistCount()
    {
        return playlist->getWidget()->count();
    }

    QWidget& getSongAddons()
    {
        return *songAddOns;
    }

    UIControl& getControls()
    {
        return *controls;
    }

    UIControl2& getControls2()
    {
        return *controls2;
    }

    UIPlaylist& getPlaylist()
    {
        return *playlist;
    }

    UILibrary& getLibrary()
    {
        return *library;
    }

    SimpleView& getSimpleView()
    {
        return *simpleview;
    }

    QHBoxLayout* getSeekSimpleLayout();


public slots:
    /*
   * Switch between big/small interface
   */
    void tabChanged();
    /*
   * Controls
   */
    void settingsDialogOpen();
    void settingsDialogAccepted();

    void savePlaylistDialog();
    void loadPlaylistDialog();

    void openUrlDialog();
    void urlDialogAccepted();
    void aboutDialogOpen();

private:
    void setupActions();
    void setupMenus();
    QWidget *mainW;
    QTabWidget *tab;
    QWidget *player;
    UIPlaylist *playlist;
    UILibrary *library;
    UIControl *controls;
    UIControl2 *controls2;
    UIControl3 *controls3;

    QHBoxLayout *mainLayout;
    QHBoxLayout *playerLayout;
    QVBoxLayout *inf_seek;
    QHBoxLayout *inf_seek_volume;
    QHBoxLayout *infosFrameLayout;
    QScrollArea *infosArea;

    QFrame *infosFrame;
    QWidget *areaW;
    QVBoxLayout *infosAreaLayout;
    QToolButton *infosSong;
    QWidget *songAddOns;
    QVBoxLayout *songAddOnsLayout;
    QLabel *songAddOnsAlbum;


    QString currDir;
    QString currCoverDir;

    QMenuBar *menu;
    QAction *loadPlaylist,*savePlaylist;
    QAction *openUrl;
    QAction *settingsAction;
    QAction *aboutAction;

    SimpleView *simpleview;
    SettingsDialog *settingsdialog;
    UrlDialog *urldialog;
    CoverDialog *coverdialog;

    QDialog *aboutDialog;
    QVBoxLayout *layoutAbout;
    QLabel *logo;
    QLabel *textApp;
    QLabel *texttrApp2;
    QLabel *texttrIandI;
    QString trApp2, trIandI, trPLFiles;

    Player *parent;

private slots:
    void infosSongPressed();
    void infosSongReleased();
    void infosSongEnableAutoRepeat();
    void infosSongClicked();
};

#endif // UI_H
