#include <iostream>
#include <QtGui>

#include "Player.h"

UIPlaylist::UIPlaylist(Player* parent)
{
	this->parent = parent;

	widgetPlaylist = new QListWidget;
	
	QStyle * s = parent->style();
	
	buttonUp = new QPushButton(s->standardIcon(QStyle::SP_ArrowUp),"");
	
	buttonDown = new QPushButton(s->standardIcon(QStyle::SP_ArrowDown),"");
	

//	buttonDel = new QPushButton(tr("Remove"));
#ifdef Q_WS_MAEMO_5
	buttonDel = new QPushButton(s->standardIcon(QStyle::SP_BrowserStop),"");
#else
	buttonDel = new QPushButton(s->standardIcon(QStyle::SP_DialogDiscardButton),"");
#endif
	
	
	//buttonDel->setFixedHeight(40);

//	buttonClear = new QPushButton(tr("Clear"));
	buttonClear = new QPushButton(s->standardIcon(QStyle::SP_TrashIcon),"");

	//buttonClear->setFixedHeight(30);

// 	buttonSave = new QPushButton(tr("Save"));
	//buttonSave->setFixedHeight(30);


	// Layout
	layout = new QVBoxLayout();

	layoutControlPL = new QHBoxLayout;
	layoutControlPL->addWidget(buttonUp);
	layoutControlPL->addWidget(buttonDown);
	layoutControlPL->addStretch();
	layoutControlPL->addWidget(buttonDel);
	layoutControlPL->addWidget(buttonClear);
	layoutControlPL->setAlignment(Qt::AlignCenter);

	connect(buttonDel, SIGNAL(clicked()), SLOT(delItem()));
	connect(buttonClear, SIGNAL(clicked()), SLOT(buttonClearPlaylist()));
	connect(widgetPlaylist, SIGNAL(itemDoubleClicked(QListWidgetItem*)), SLOT(playlistDoubleClicked()));
	
	connect(buttonUp, SIGNAL(clicked()), SLOT(upItem()));
	connect(buttonDown, SIGNAL(clicked()), SLOT(downItem()));
	
	layout->addWidget(widgetPlaylist);
	layout->addLayout(layoutControlPL);
	setLayout(layout);
}

UIPlaylist::~UIPlaylist()
{
  if (buttonDel)
      delete buttonDel;
  if (buttonClear)
      delete buttonClear;
  if (widgetPlaylist)
      delete widgetPlaylist;
  if (layoutControlPL)
      delete layoutControlPL;
  if (layout)
      delete layout;
}

void
UIPlaylist::playlistDoubleClicked()
{
	parent->play(currentRow());
}

void
UIPlaylist::addItem(QString s)
{
	QListWidgetItem* item = new QListWidgetItem(s);
	widgetPlaylist->addItem(item);
}

void
UIPlaylist::delItem()
{
	int row = currentRow();
	QListWidgetItem* item = widgetPlaylist->takeItem(row);
	if (item)
	{
		delete item;
		parent->engine->delMedia(row);
	}
}

void
UIPlaylist::changeItem(QString s,int row, bool disabled)
{
	QListWidgetItem* item = widgetPlaylist->item(row);
	if (item)
	{
	    item->setText(s);
	    if(disabled)
	    {
	      QBrush tmpbrush;
	      tmpbrush.setColor(Qt::red);
	      item->setForeground(tmpbrush);
	    }
	}
}

void
UIPlaylist::setBold(unsigned int row, bool b)
{
	QListWidgetItem* item = widgetPlaylist->item(row);
	if (item)
	{
		QFont tmp;
		tmp.setBold(b);		
		item->setFont(tmp);
	}
}


void
UIPlaylist::buttonClearPlaylist()
{
	parent->engine->clearPlayList();
}

void
UIPlaylist::clearPlaylist()
{
	widgetPlaylist->clear();
}


void UIPlaylist::upItem()
{
 int row = currentRow();
 
 if(row>0)
 {
  QListWidgetItem* item = widgetPlaylist->takeItem(row-1);
  widgetPlaylist->insertItem(row,item);
    
  parent->engine->moveMedia(row,true);
  
  //widgetPlaylist->setCurrentRow(row-1);
  widgetPlaylist->scrollToItem(widgetPlaylist->item(row-1)); 

 }
 
 
 
}

void UIPlaylist::downItem()
{
 int row = currentRow();
  
 if((row<widgetPlaylist->count()-1)&&(row>=0))
 {
  QListWidgetItem* item = widgetPlaylist->takeItem(row+1);
  widgetPlaylist->insertItem(row,item);
    
  parent->engine->moveMedia(row,false);
  
  //widgetPlaylist->setCurrentRow(row+1);
  widgetPlaylist->scrollToItem(widgetPlaylist->item(row+1)); 

 }
  
  
}

int UIPlaylist::currentRow()
{
  //this hack is needed for scroll bug in maemo: current item is changed when scrolling playlist
  int current=-1;
  QList<QListWidgetItem *> list=widgetPlaylist->selectedItems();
  if(list.size()>0)
  {
    QListWidgetItem * item;
    //qDebug()<<"---";

    item=list.at(0);
    current=widgetPlaylist->row(item);
    //qDebug()<<current;
  }
  return current;
}



