#ifndef UIPLAYLIST_H
#define UIPLAYLIST_H

#include <QtCore>
#include <QtGui>

class Player;

class UIPlaylist : public QWidget
{
		Q_OBJECT
	public:
		/*
		 * Constructor
		 */
		UIPlaylist(Player* parent);
		
		~UIPlaylist();

		/*
		 * Return the playlist widget
		 */
		QListWidget* getWidget()
		{
			return widgetPlaylist;
		}

		/*
		 * Return the current selected row
		 */
		int currentRow();

// 		void setCurrentRow(int row)
// 		{
// 		  widgetPlaylist->setCurrentRow(row);
// 		}

		/*
		 * Add a media in the playlist
		 */
		void addItem(QString s);
		void changeItem(QString s,int row,bool disabled=false);

		/*
		 * Set bold/Unbold a row of the playlist
		 */
		void setBold(unsigned int row, bool b);

	public slots:
		void clearPlaylist(); // clear the widget
		void buttonClearPlaylist(); // clear the content & the widget
		void playlistDoubleClicked();
		void delItem();
		void upItem();
		void downItem();

	private:
		QListWidget* widgetPlaylist;
		QPushButton* buttonDel, *buttonClear;
		QPushButton* buttonUp, *buttonDown;
		QHBoxLayout* layoutControlPL;
		QVBoxLayout* layout;

		Player* parent;
};

#endif // UIPLAYLIST_H
