#include <iostream>
#include <QtGui>

#include "Player.h"
#include "UI.h"

UI::UI(Player* parent, QString& musicPath)
{
	this->parent = parent;
	
	setupActions();
	setupMenus();
	
	workdir=QDesktopServices::storageLocation(QDesktopServices::HomeLocation);

	//QStyle* style = this->style();

	// Initialize the random
	qsrand(time(NULL));
	
	areaW = new QWidget();
	
	infosArea = new QScrollArea();
	infosArea->setWidgetResizable(true);
	infosArea->setAlignment(Qt::AlignCenter);
// 	infosLayout=new QVBoxLayout;
	
	infosSong = new QLabel(areaW);
	infosSong->setText("\n");
	infosSong->setAlignment(Qt::AlignCenter);
	//infosSong->setFrameStyle(QFrame::StyledPanel);
	infosLayout=new QVBoxLayout(areaW);
	infosLayout->addWidget(infosSong);
	//infosLayout->setSizeConstraint(QLayout::SetNoConstraint);
	//infosArea->setLayout(infosLayout);
	infosArea->setWidget(areaW);
	//infosSong->setWordWrap(true);
	
	// Controls
	controls = new UIControl(parent);
	// Playlist
	playlist = new UIPlaylist(parent);
	// Folder
	folder = new UIFolder(parent,musicPath);
	// Settings
	//settings = new UISettings(parent, musicPath);

	// Tab
	tab = new QTabWidget;
	tab->addTab(playlist, tr("Playlist"));
	tab->addTab(folder, tr("Files"));
	//tab->addTab(settings,"Settings");

	// Layouts
	mainLayout = new QHBoxLayout;
	ctrlLayout = new QVBoxLayout;
//	mainLayout->addWidget(infosSong);
//	mainLayout->addLayout(parent->engine->getSeekLayout());
//	mainLayout->addWidget(controls);
	//
	inf_seek=new QVBoxLayout;
	inf_seek->addSpacing(10);
	inf_seek->addWidget(infosArea);
	inf_seek->addLayout(parent->engine->getSeekLayout());

	inf_seek_volume=new QHBoxLayout;
	inf_seek_volume->addLayout(inf_seek);
	inf_seek_volume->addLayout(parent->engine->getVolLayout());

	ctrlLayout->addLayout(inf_seek_volume);
	ctrlLayout->addWidget(controls);
	//ctrlLayout->addStretch();

	mainLayout->addLayout(ctrlLayout);
//	mainLayout->addLayout(parent->engine->getVolLayout());
	mainLayout->addWidget(tab);

	mainLayout->setSpacing(0);

	// Accept drag'n'drop
	setAcceptDrops(false);

	// UI
	//setMinimumSize(250,80);
	//setLayout(mainLayout);
	mainW = new QWidget();
	mainW->setLayout(mainLayout);
	setCentralWidget(mainW);
	
	tab->setVisible(!parent->config->simpleView);
	//adjustSize();
	
	settingsdialog = new SettingsDialog();
	connect(settingsdialog, SIGNAL(accepted()), this, SLOT(settingsDialogAccepted()));
	
	urldialog = new UrlDialog();
	connect(urldialog, SIGNAL(accepted()), this, SLOT(urlDialogAccepted()));

	setWindowTitle("NecroPlayer");
	show();
}
UI::~UI()
{
	//qDebug()<<"UI destructor";
	if (infosSong)
		delete infosSong;
	if (infosLayout)
		delete infosLayout;
	if (infosArea)
		delete infosArea;
	if (controls)
		delete controls; controls = NULL;
	if (folder)
		delete folder; folder = NULL;
// 	if (settings)
// 		delete settings; settings = NULL;
	if (tab)
		delete tab;
	if (inf_seek)
		delete inf_seek;
	if (inf_seek_volume)
		delete inf_seek_volume;
	if (ctrlLayout)
		delete ctrlLayout;
	if (mainLayout)
		delete mainLayout;
	if (mainW)
		delete mainW;

	
	
}

void
UI::toggleInterface()
{
	tab->setVisible(!tab->isVisible());
	if(tab->isVisible())
	    parent->config->simpleView=false;
	else
	    parent->config->simpleView=true;
	
	//adjustSize();
}


void
UI::clearPlaylist()
{
	playlist->clearPlaylist(); 
}


void
UI::playlistAdd(QStringList ss)
{
	parent->engine->addMedia(ss);
	parent->engine->startMetaUpdater();
}

void
UI::addItem(QString s)
{
	playlist->addItem(s);
}

void UI::changeItem(QString s, int row, bool disabled)
{
	playlist->changeItem(s,row,disabled);
}

void
UI::play()
{
	parent->play(-1);
}

void
UI::stop()
{
	parent->stop();
}

void
UI::next()
{
	parent->next();
}

void
UI::prev()
{
	parent->prev();
}


void
UI::setInfos(QString s)
{
	infosSong->setText(s);
}

void UI::setupActions()
{
  settingsAction = new QAction(tr("Settings"),this);
  connect(settingsAction, SIGNAL(triggered()), this, SLOT(settingsDialogOpen()));
  
  loadPlaylist =  new QAction(tr("Open Playlist"),this);
  connect(loadPlaylist, SIGNAL(triggered()), this, SLOT(loadPlaylistDialog()));
  
  savePlaylist =  new QAction(tr("Save Playlist"),this);
  connect(savePlaylist, SIGNAL(triggered()), this, SLOT(savePlaylistDialog()));
  
  openUrl = new QAction(tr("Open Url"),this);
  connect(openUrl, SIGNAL(triggered()), this, SLOT(openUrlDialog()));
  
  
  
}

void UI::setupMenus()
{
  fileMenu = menuBar()->addMenu(tr("File"));
  fileMenu->addAction(loadPlaylist);
  fileMenu->addAction(savePlaylist);
  fileMenu->addAction(openUrl);
  
  settingsMenu = menuBar()->addMenu(tr("Settings"));
  settingsMenu->addAction(settingsAction);
  
}

void UI::settingsDialogOpen()
{
  settingsdialog->setConfig(parent->config);
  settingsdialog->exec();
  
}

void UI::settingsDialogAccepted()
{
  //qDebug()<<"Setting Dialog Accepted";
  bool tmpUseTags=parent->config->useTags;
  bool tmpUpdateOnPlay=parent->config->updateOnPlay;
  QString tmpFolder=parent->config->musicFolder;
  settingsdialog->getConfig(parent->config);
  //if(((tmpUseTags==false)&&(parent->config->useTags==true))||
  // ((tmpUpdateOnPlay==true)&&(parent->config->updateOnPlay==false)&&(parent->config->useTags==true)))
  if((tmpUseTags!=parent->config->useTags)||(tmpUpdateOnPlay!=parent->config->updateOnPlay))
    parent->engine->startMetaUpdater(true);
  
  if(tmpFolder!=parent->config->musicFolder)
    folder->refreshWithNewMusicPath(parent->config->musicFolder);
  
  
}

void UI::loadPlaylistDialog()
{

  QString tmpfile;
  
  tmpfile=QFileDialog::getOpenFileName(this,tr("Open Playlist"),workdir,
				       tr("Playlist files ( *.m3u *.M3U *.pls *.PLS)"));
  
  if(!tmpfile.isNull())
  {
    if(tmpfile.endsWith(".pls",Qt::CaseInsensitive))
    {
      parent->openPlaylist_pls(tmpfile);
    }
    else
    {
      parent->restorePlaylist(tmpfile);
    }
    
    parent->engine->startMetaUpdater();
    
    QFileInfo tmpinfo(tmpfile);
    workdir=tmpinfo.dir().absolutePath();
  }
}

void UI::savePlaylistDialog()
{
  QString tmpfile;
  
  tmpfile=QFileDialog::getSaveFileName(this,tr("Save Playlist"),workdir,
					tr("Playlist files ( *.m3u *.M3U)"));
  
  if((!tmpfile.isNull())&&(!tmpfile.isEmpty()))
  {
    if(!tmpfile.endsWith(".m3u",Qt::CaseInsensitive))
      tmpfile.append(".m3u");
      
    parent->savePlaylist(tmpfile);  
    QFileInfo tmpinfo(tmpfile);
    workdir=tmpinfo.dir().absolutePath();
  }
}

void UI::openUrlDialog()
{
  urldialog->setUrl("");
  urldialog->exec();
}

void UI::urlDialogAccepted()
{
  QString tmpstr=urldialog->getUrl();
  if((!tmpstr.isNull())&&(!tmpstr.isEmpty()))
  {
    QStringList tmplist;
    tmplist.append(tmpstr);
    playlistAdd(tmplist);
 
  } 
}

