#ifndef ENGINE_H
#define ENGINE_H

#include <QtGui>

#include <phonon/seekslider.h>
#include <phonon/audiooutput.h>
#include <phonon/mediaobject.h>
#include <phonon/mediasource.h>
#include <phonon/volumeslider.h>


typedef struct Media
{
	QString artist;
	QString title;
	QString album;
	QString totalTime;
} Media;

class Player;

class Engine : public QObject
{
	Q_OBJECT
	public:
		Engine(Player *parent);

		~Engine();

		/**
		 * Return the row played, or -1 if an error occured
		 */
		int play(int row);

		/*
		 * Stop playing
		 */
		void stop();


		/*
		 * The content of the seekbar (in a layout)
		 */
		QVBoxLayout* getSeekLayout()
		{
			return seekLayout;
		}
                QVBoxLayout* getVolLayout()
                {
                        return volLayout;
                }

		qreal getVolume()
		{
			return audioOutput->volume();
		}
		void setVolume(qreal vol)
		{
			audioOutput->setVolume(vol);
		}
		qint64 getCurrentTime()
		{
		  return mediaObject->currentTime();
		}
		void restoreState(int row, qint64 time);

		/*
		 * Add a media
		 */
		void addMedia(QStringList files);

		/*
		 * Delete a media
		 */
		int delMedia(int row);
		int moveMedia(int row, bool moveUp);

		/*
		 * Return info on a file
		 */
		Media getInfos(unsigned int row);

		/*
		 * Return the index of the currently played media
		 */
		int getCurrentPlayedMedia();

		void setCurrentPlayedMedia(int current)
		{
			currentPlayedMedia=current;
		}

		/*
		 * Return the uri index 'row'
		 */
		QString getUri(unsigned int row);
		
		int getNUris();
		
		/*
		 * Clear every list : playlist, media list, uris list sources list
		 */
		void clearPlayList();

		/*
		 * Convert a time in milliseconds to a human readable string (3:40)
		 */
		static QString msToString(qint64 ms);
		
		void startMetaUpdater(bool reload=false);

		/*
		 * Return the state of the player (is it playing ? paused ?)
		 */
		Phonon::State getReadingState()
		{
			Phonon::State ret = Phonon::ErrorState;
			if (mediaObject)
			{
				ret = mediaObject->state();
			}
			return ret;
		}

		

	public slots:
		void metaInfosUpdated(Phonon::State state, Phonon::State oldState);
		void currentInfosUpdated(Phonon::State newState, Phonon::State oldState);
		void refreshPlayedTime();
		void playEnded();
		void setInitialPosition(Phonon::State state);

	private:		
		int currentPlayedMedia;

		Phonon::SeekSlider* seekSlider;
		Phonon::AudioOutput* audioOutput;
		Phonon::MediaObject* mediaObject;	
		Phonon::MediaObject* mediaObjectForMetaInfos;
		Phonon::VolumeSlider *volumeSlider;

		QVBoxLayout* seekLayout;
		QHBoxLayout* timeLayout;
                QVBoxLayout* volLayout;

		QLabel *currentTime, *totalTime;

		QVector<Media> listMedias;
		QVector<Phonon::MediaSource> listSources;
		QVector<QString> listUris;
		Media tmpMedia;
		
		Player* parent;
		
		int lastUpdated;
		
		qint64 init_position;
		bool initial;
};

#endif
