#ifndef UI_H
#define UI_H

#include <QtGui>
//#include <Phonon/VolumeSlider>

#include "UIFolder.h"
#include "UIPlaylist.h"
//#include "UISettings.h"
#include "UIControl.h"
#include "SettingsDialog.h"
#include "UrlDialog.h"

class Player;

class UI : public QMainWindow
{
		Q_OBJECT
	public:
		UI(Player* parent,QString& musicPath);
		~UI();

		/*
		 * Add a file in the playlist
		 */
		void playlistAdd(QStringList ss);
		/*
		 * Clear the playlist
		 */
		void clearPlaylist();

//		bool random;
		
		void addItem(QString s);
		
		void changeItem(QString s,int row, bool disable=false);

		void setInfos(QString s);

		/*
		 * Return the current selected row in the playlist
		 */
		int playlistCurrentRow()
		{
			return playlist->currentRow();
		}

		/*
		 * Return how many files in the playlist
		 */
		int playlistCount()
		{
			return playlist->getWidget()->count();
		}
		/*
		 * Change the selected row in the playlist
		 */
		void setSelectedRow(unsigned int row)
		{
			playlist->getWidget()->setCurrentRow(row);
		}


		UIControl& getControls()
		{
			return *controls;
		}


		UIPlaylist& getPlaylist()
		{
			return *playlist;
		}
	

	public slots:
		/*
		 * Switch between big/small interface
		 */	
		void toggleInterface();
		/*
		 * Controls
		 */
		void play();
		void next();
		void prev();
		void stop();
		
		void settingsDialogOpen();
		void settingsDialogAccepted();
		
		void savePlaylistDialog();
		void loadPlaylistDialog();
		
		void openUrlDialog();
		void urlDialogAccepted();

		// Tray quit
		//void tQuit();


	private:
		void setupActions();
		void setupMenus();
		QWidget *mainW;
		QTabWidget* tab;
		UIPlaylist* playlist;
		UIFolder* folder;
		UIControl* controls;
		//UISettings* settings;
		
		
		QHBoxLayout* mainLayout;
		QVBoxLayout* inf_seek;
		QHBoxLayout* inf_seek_volume;
		QVBoxLayout* ctrlLayout;
		QScrollArea *infosArea;
		
		QWidget *areaW;
		QVBoxLayout* infosLayout;
		QLabel* infosSong;
		
		QString workdir;
		
		QAction *settingsAction;
		QAction *loadPlaylist,*savePlaylist;
		QAction *openUrl;
		QMenu *settingsMenu,*fileMenu;
		
		SettingsDialog *settingsdialog;
		UrlDialog *urldialog;



		Player* parent;
};

#endif // UI_H
