#include <iostream>
#include <QtGui>

#include "Player.h"

UIPlaylist::UIPlaylist(Player* parent)
{
	this->parent = parent;

	widgetPlaylist = new QListWidget;
	
	QStyle * s = parent->style();
	
	buttonUp = new QPushButton(s->standardIcon(QStyle::SP_ArrowUp),"");
	
	buttonDown = new QPushButton(s->standardIcon(QStyle::SP_ArrowDown),"");
	

//	buttonDel = new QPushButton(tr("Remove"));
	buttonDel = new QPushButton(s->standardIcon(QStyle::SP_DialogDiscardButton),"");
	
	//buttonDel->setFixedHeight(40);

//	buttonClear = new QPushButton(tr("Clear"));
	buttonClear = new QPushButton(s->standardIcon(QStyle::SP_TrashIcon),"");

	//buttonClear->setFixedHeight(30);

// 	buttonSave = new QPushButton(tr("Save"));
	//buttonSave->setFixedHeight(30);


	// Layout
	layout = new QVBoxLayout();

	layoutControlPL = new QHBoxLayout;
	layoutControlPL->addWidget(buttonUp);
	layoutControlPL->addWidget(buttonDown);
	layoutControlPL->addStretch();
	layoutControlPL->addWidget(buttonDel);
	layoutControlPL->addWidget(buttonClear);
	layoutControlPL->setAlignment(Qt::AlignCenter);

	connect(buttonDel, SIGNAL(clicked()), SLOT(delItem()));
	connect(buttonClear, SIGNAL(clicked()), SLOT(buttonClearPlaylist()));
	connect(widgetPlaylist, SIGNAL(itemDoubleClicked(QListWidgetItem*)), SLOT(playlistDoubleClicked()));
	
	connect(buttonUp, SIGNAL(clicked()), SLOT(upItem()));
	connect(buttonDown, SIGNAL(clicked()), SLOT(downItem()));
	
	layout->addWidget(widgetPlaylist);
	layout->addLayout(layoutControlPL);
	setLayout(layout);
}

UIPlaylist::~UIPlaylist()
{
  if (buttonDel)
      delete buttonDel;
  if (buttonClear)
      delete buttonClear;
  if (widgetPlaylist)
      delete widgetPlaylist;
  if (layoutControlPL)
      delete layoutControlPL;
  if (layout)
      delete layout;
}

void
UIPlaylist::playlistDoubleClicked()
{
	parent->play(widgetPlaylist->currentRow());
}

void
UIPlaylist::addItem(QString s)
{
	QListWidgetItem* item = new QListWidgetItem(s);
	widgetPlaylist->addItem(item);
}

void
UIPlaylist::delItem()
{
	int row = widgetPlaylist->currentRow();
	QListWidgetItem* item = widgetPlaylist->takeItem(row);
	if (item)
	{
		delete item;
		parent->engine->delMedia(row);
	}
}

void
UIPlaylist::changeItem(QString s,int row, bool disabled)
{
	QListWidgetItem* item = widgetPlaylist->item(row);
	if (item)
	{
	    item->setText(s);
	    if(disabled)
	    {
	      QBrush tmpbrush;
	      tmpbrush.setColor(Qt::red);
	      item->setForeground(tmpbrush);
	    }
	}
}

void
UIPlaylist::setBold(unsigned int row, bool b)
{
	QListWidgetItem* item = widgetPlaylist->item(row);
	if (item)
	{
		QFont tmp;
		tmp.setBold(b);		
		item->setFont(tmp);
	}
}

void
UIPlaylist::savePlaylist()
{
	int count = parent->ui->playlistCount();
	int i;
	QFile file(parent->config->configDir.path()+ "/necroplayer_list");
	QTextStream out(&file);
	if (file.open(QIODevice::WriteOnly | QIODevice::Text))
	{
		for (i = 0; i < count; i++)
		{
			out << parent->engine->getUri(i) << '\n';
		}
	}
	file.close();
}

void
UIPlaylist::buttonClearPlaylist()
{
	parent->engine->clearPlayList();
}

void
UIPlaylist::clearPlaylist()
{
	widgetPlaylist->clear();
}


void UIPlaylist::upItem()
{
 int row = widgetPlaylist->currentRow();
 
 if(row>0)
 {
  QListWidgetItem *item  = widgetPlaylist->item(row);
  QString tmpString=item->text();
  QBrush tmpbrush=item->foreground();
  QFont tmpfont=item->font();
  
  QListWidgetItem* item2 = widgetPlaylist->item(row-1);
  QString tmpString2=item2->text();
  QBrush tmpbrush2=item2->foreground();
  QFont tmpfont2=item2->font();
  
  item->setText(tmpString2);
  item->setForeground(tmpbrush2);
  item->setFont(tmpfont2);
  
  item2->setText(tmpString);
  item2->setForeground(tmpbrush);
  item2->setFont(tmpfont);
    
  parent->engine->moveMedia(row,true);
  
  widgetPlaylist->setCurrentRow(row-1);
 }
 
 
 
}

void UIPlaylist::downItem()
{
 int row = widgetPlaylist->currentRow();
  
 if((row<widgetPlaylist->count()-1)&&(row>=0))
 {
  QListWidgetItem *item  = widgetPlaylist->item(row);
  QString tmpString=item->text();
  QBrush tmpbrush=item->foreground();
  QFont tmpfont=item->font();
  
  QListWidgetItem* item2 = widgetPlaylist->item(row+1);
  QString tmpString2=item2->text();
  QBrush tmpbrush2=item2->foreground();
  QFont tmpfont2=item2->font();
  
  item->setText(tmpString2);
  item->setForeground(tmpbrush2);
  item->setFont(tmpfont2);
  
  item2->setText(tmpString);
  item2->setForeground(tmpbrush);
  item2->setFont(tmpfont);
    
  parent->engine->moveMedia(row,false);
  
  widgetPlaylist->setCurrentRow(row+1);
 }
  
}




