#include "SettingsDialog.h"



SettingsDialog::SettingsDialog()
{
  scrArea = new QScrollArea(this);
  scrollW = new QWidget(scrArea);
  scrArea->setWidgetResizable(true);
  scrollLayout = new QVBoxLayout(scrollW);
  //configLayout = new QVBoxLayout(this);
  #ifdef Q_WS_MAEMO_5
  configLayout = new QHBoxLayout(this);
  #else
  configLayout = new QVBoxLayout(this);
  #endif
  
  playlistBox = new QGroupBox(scrollW);
  playlistBox->setTitle(tr("Playlist"));
  playlistBox->setObjectName("Playlist Box");
  
  playlistLayout = new QVBoxLayout(playlistBox);
 
  useTagsOrNames = new QButtonGroup(this);
  
  useTags = new QRadioButton(scrollW);
  useTags->setText(tr("Metadata"));
  useFileNames = new QRadioButton(scrollW);
  useFileNames->setText(tr("Filenames"));
  
  useTagsOrNames->addButton(useTags);
  useTagsOrNames->addButton(useFileNames);
  
  tagsLayout = new QHBoxLayout();
  
  tagsLayout->addWidget(useTags);
  tagsLayout->addWidget(useFileNames);
  
  playlistLayout->addLayout(tagsLayout);
  
  updateOnAddingOrPlaying = new QButtonGroup(scrollW);
  
  labelMetadata = new QLabel(scrollW);
  labelMetadata->setText(tr("Retrieve metadata:"));
  
  updateOnAdding = new QRadioButton(scrollW);
  updateOnAdding->setText(tr("Playlist"));
  updateOnPlaying = new QRadioButton(scrollW);
  updateOnPlaying->setText(tr("Played song"));
  
  updateOnAddingOrPlaying->addButton(updateOnAdding);
  updateOnAddingOrPlaying->addButton(updateOnPlaying);
  playlistLayout->addWidget(labelMetadata);
  //playlistLayout->addWidget(updateOnAdding);
  //playlistLayout->addWidget(updateOnPlaying);
  tagsOptLayout = new QHBoxLayout();
  tagsOptLayout->addWidget(updateOnAdding);
  tagsOptLayout->addWidget(updateOnPlaying);
  playlistLayout->addLayout(tagsOptLayout);
  
//   savePlaylistOnQuit = new QCheckBox(scrollW);
//   savePlaylistOnQuit->setText(tr("Save playlist on quit"));
//   
//   playlistLayout->addWidget(savePlaylistOnQuit);
  
  savePositionOnQuit = new QCheckBox(scrollW);
  savePositionOnQuit->setText(tr("Save playing position on quit"));
  playlistLayout->addWidget(savePositionOnQuit);
  
  playlistBox->setLayout(playlistLayout);
  
  
  //playlistLayout->addWidget(useTagsOrNames);
  playlistBox->setLayout(playlistLayout);

  scrollLayout->addWidget(playlistBox);
  //scrArea->AddLayout(playlistBox);
  
  directoryBox = new QGroupBox(scrollW);
  directoryBox->setTitle(tr("Music Directory"));
  directoryBox->setObjectName("Music Directory Box");
  directoryLayout = new QVBoxLayout(directoryBox);
  
  directoryLayout2 = new QHBoxLayout();
    
  labelDirectory = new QLabel(scrollW);
  labelDirectory->setText(tr("Directory:"));
  
  directoryLayout2->addWidget(labelDirectory);
  
  directory = new QLineEdit(scrollW);
  directoryLayout2->addWidget(directory);
  
  buttonDir = new QPushButton(scrollW);
  buttonDir->setText(tr("Browse"));
  
  directoryLayout2->addWidget(buttonDir);
  
  directoryLayout->addLayout(directoryLayout2);
  
  showHiddenFiles = new QCheckBox(scrollW);
  showHiddenFiles->setText(tr("Show hidden files"));
  
  directoryLayout->addWidget(showHiddenFiles);
  
  directoryBox->setLayout(directoryLayout);
  
  scrollLayout->addWidget(directoryBox);
  scrArea->setWidget(scrollW);
  //setLayout(configLayout);
  
  dialogButtons = new QDialogButtonBox(this);
  dialogButtons->setStandardButtons(QDialogButtonBox::Ok|QDialogButtonBox::Cancel);
  #ifdef Q_WS_MAEMO_5
  dialogButtons->setOrientation(Qt::Vertical);
  #endif
  
  configLayout->addWidget(scrArea);
  configLayout->addWidget(dialogButtons);
  
  
  setWindowTitle(tr("Settings"));
  
  connect(useFileNames,SIGNAL(toggled(bool)),updateOnAdding,SLOT(setDisabled(bool)));
  connect(useFileNames,SIGNAL(toggled(bool)),updateOnPlaying,SLOT(setDisabled(bool)));
  connect(useFileNames,SIGNAL(toggled(bool)),labelMetadata,SLOT(setDisabled(bool)));
  
  connect(buttonDir,SIGNAL(clicked()),this,SLOT(browseDir()));
  
  connect(dialogButtons,SIGNAL(accepted()),this,SLOT(accept()));
  connect(dialogButtons,SIGNAL(rejected()),this,SLOT(reject()));
  
  
  
  //cfg = new Config();
  
}

SettingsDialog::~SettingsDialog()
{  
}



void SettingsDialog::setConfig(Config* inputConfig)
{  
  if (inputConfig->useTags)
    useTags->setChecked(true);
  else 
    useFileNames->setChecked(true);
  
  if (inputConfig->updateOnPlay)
    updateOnPlaying->setChecked(true);
  else
    updateOnAdding->setChecked(true);
  
//   savePlaylistOnQuit->setChecked(inputConfig->savePlaylistOnQuit);
  savePositionOnQuit->setChecked(inputConfig->savePosition);  
  
  directory->setText(inputConfig->musicFolder);
  
  showHiddenFiles->setChecked(inputConfig->showHidden);

}

void SettingsDialog::getConfig(Config* outputConfig)
{

    outputConfig->useTags=useTags->isChecked();
    outputConfig->updateOnPlay=updateOnPlaying->isChecked();
//     outputConfig->savePlaylistOnQuit=savePlaylistOnQuit->isChecked();
    outputConfig->savePosition=savePositionOnQuit->isChecked();
    
    outputConfig->musicFolder=directory->text();
    outputConfig->showHidden=showHiddenFiles->isChecked();
  
}

void SettingsDialog::browseDir()
{
  QString res = QFileDialog::getExistingDirectory ( this, tr("Select your music directory"), directory->text(), QFileDialog::ShowDirsOnly );
  if (!res.isNull())
  {
    directory->setText(res);
  }
  
}
