#include <iostream>
#include <QtGui>

#include "UPlay.h"
#include "UI.h"

UI::UI(UPlay* parent, QString& musicPath)
{
	this->parent = parent;
	
	setupActions();
	setupMenus();

	//QStyle* style = this->style();

	// Initialize the random
	qsrand(time(NULL));
	
	areaW = new QWidget();
	
	infosArea = new QScrollArea();
	infosArea->setWidgetResizable(true);
	infosArea->setAlignment(Qt::AlignCenter);
// 	infosLayout=new QVBoxLayout;
	
	infosSong = new QLabel(areaW);
	infosSong->setText("\n");
	infosSong->setAlignment(Qt::AlignCenter);
	//infosSong->setFrameStyle(QFrame::StyledPanel);
	infosLayout=new QVBoxLayout(areaW);
	infosLayout->addWidget(infosSong);
	//infosLayout->setSizeConstraint(QLayout::SetNoConstraint);
	//infosArea->setLayout(infosLayout);
	infosArea->setWidget(areaW);
	//infosSong->setWordWrap(true);
	
	// Controls
	controls = new UIControl(parent);
	// Playlist
	playlist = new UIPlaylist(parent);
	// Folder
	folder = new UIFolder(parent,musicPath);
	// Settings
	//settings = new UISettings(parent, musicPath);

	// Tab
	tab = new QTabWidget;
	tab->addTab(playlist, tr("Playlist"));
	tab->addTab(folder, tr("Files"));
	//tab->addTab(settings,"Settings");

	// Layouts
	mainLayout = new QHBoxLayout;
	ctrlLayout = new QVBoxLayout;
//	mainLayout->addWidget(infosSong);
//	mainLayout->addLayout(parent->engine->getSeekLayout());
//	mainLayout->addWidget(controls);
	//
	inf_seek=new QVBoxLayout;
	inf_seek->addSpacing(10);
	inf_seek->addWidget(infosArea);
	inf_seek->addLayout(parent->engine->getSeekLayout());

	inf_seek_volume=new QHBoxLayout;
	inf_seek_volume->addLayout(inf_seek);
	inf_seek_volume->addLayout(parent->engine->getVolLayout());

	ctrlLayout->addLayout(inf_seek_volume);
	ctrlLayout->addWidget(controls);
	ctrlLayout->addStretch();

	mainLayout->addLayout(ctrlLayout);
//	mainLayout->addLayout(parent->engine->getVolLayout());
	mainLayout->addWidget(tab);

	mainLayout->setSpacing(0);

	// Accept drag'n'drop
	setAcceptDrops(false);

	// UI
	//setMinimumSize(250,80);
	//setLayout(mainLayout);
	mainW = new QWidget();
	mainW->setLayout(mainLayout);
	setCentralWidget(mainW);
	
	tab->setVisible(!parent->config->simpleView);
	//adjustSize();
	
	settingsdialog = new SettingsDialog();
	connect(settingsdialog, SIGNAL(accepted()), this, SLOT(settingsDialogAccepted()));

	setWindowTitle("NecroPlayer");
	show();
}
UI::~UI()
{
	//qDebug()<<"UI destructor";
	if (infosSong)
		delete infosSong;
	if (infosLayout)
		delete infosLayout;
	if (infosArea)
		delete infosArea;
	if (controls)
		delete controls; controls = NULL;
	if (folder)
		delete folder; folder = NULL;
// 	if (settings)
// 		delete settings; settings = NULL;
	if (tab)
		delete tab;
	if (inf_seek)
		delete inf_seek;
	if (inf_seek_volume)
		delete inf_seek_volume;
	if (ctrlLayout)
		delete ctrlLayout;
	if (mainLayout)
		delete mainLayout;
	if (mainW)
		delete mainW;

	
	
}

void
UI::toggleInterface()
{
	tab->setVisible(!tab->isVisible());
	if(tab->isVisible())
	    parent->config->simpleView=false;
	else
	    parent->config->simpleView=true;
	
	//adjustSize();
}


void
UI::clearPlaylist()
{
	playlist->clearPlaylist(); 
}


void
UI::playlistAdd(QStringList ss)
{
	parent->engine->addMedia(ss);
	parent->engine->startMetaUpdater();
}

void
UI::addItem(QString s)
{
	playlist->addItem(s);
}

void UI::changeItem(QString s, int row)
{
	playlist->changeItem(s,row);
}

void
UI::play()
{
	parent->play(-1);
}

void
UI::stop()
{
	parent->stop();
}

void
UI::next()
{
	parent->next();
}

void
UI::prev()
{
	parent->prev();
}


void
UI::setInfos(QString s)
{
	infosSong->setText(s);
}

void UI::setupActions()
{
  settingsAction = new QAction(tr("Settings"),this);
  connect(settingsAction, SIGNAL(triggered()), this, SLOT(settingsDialogOpen()));
  
  
}

void UI::setupMenus()
{
  settingsMenu = menuBar()->addMenu(tr("Settings"));
  settingsMenu->addAction(settingsAction);
  
}

void UI::settingsDialogOpen()
{
  settingsdialog->setConfig(parent->config);
  settingsdialog->show();
  
}

void UI::settingsDialogAccepted()
{
  //qDebug()<<"Setting Dialog Accepted";
  bool tmpUseTags=parent->config->useTags;
  bool tmpUpdateOnPlay=parent->config->updateOnPlay;
  settingsdialog->getConfig(parent->config);
  if(((tmpUseTags==false)&&(parent->config->useTags==true))||
   ((tmpUpdateOnPlay==true)&&(parent->config->updateOnPlay==false)&&(parent->config->useTags==true)))
    parent->engine->startMetaUpdater(true);
  
  folder->refreshWithNewMusicPath(parent->config->musicFolder);
  
  
}



