#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QtCore>
#include <QtGui>
#include "Config.h"

class SettingsDialog : public QDialog
{
  Q_OBJECT
public:
  SettingsDialog();
  ~SettingsDialog();
  void setConfig(Config* inputConfig);
  void getConfig(Config* outputConfig);
  
private:
  QVBoxLayout* dialogLayout;
  QVBoxLayout* configLayout;
  QHBoxLayout* tagsLayout;
  
  QGroupBox* playlistBox;
  QVBoxLayout* playlistLayout;
  QButtonGroup *useTagsOrNames;
  QRadioButton* useTags;
  QRadioButton* useFileNames;
  
  QButtonGroup *updateOnAddingOrPlaying;
  QRadioButton* updateOnAdding;
  QRadioButton* updateOnPlaying;
  
  QCheckBox* savePlaylistOnQuit;
  
  
  QVBoxLayout* directoryLayout;
  QHBoxLayout* directoryLayout2;
  QGroupBox* directoryBox;  
  
  QLabel* labelDirectory;
  QLineEdit* directory;
  QPushButton* buttonDir;
  
  QCheckBox* showHiddenFiles;
  
  QDialogButtonBox* dialogButtons;

  //QWidget* configW;
  //Config* cfg;
  private slots:
    void browseDir();
};
#endif