#ifndef ENGINE_H
#define ENGINE_H

#include <QtGui>

#include <phonon/seekslider.h>
#include <phonon/audiooutput.h>
#include <phonon/mediaobject.h>
#include <phonon/mediasource.h>
#include <phonon/volumeslider.h>


typedef struct Media
{
	QString artist;
	QString title;
	QString album;
	QString totalTime;
} Media;

class UPlay;

class Engine : public QObject
{
	Q_OBJECT
	public:
		Engine(UPlay *parent);

		~Engine();

		/**
		 * Return the row played, or -1 if an error occured
		 */
		int play(int row);

		/*
		 * Stop playing
		 */
		void stop();


		/*
		 * The content of the seekbar (in a layout)
		 */
		QVBoxLayout* getSeekLayout()
		{
			return seekLayout;
		}
                QVBoxLayout* getVolLayout()
                {
                        return volLayout;
                }

		qreal getVolume()
		{
			return audioOutput->volume();
		}
		void setVolume(qreal vol)
		{
			audioOutput->setVolume(vol);
		}


		/*
		 * Add a media
		 */
		void addMedia(QStringList files);

		/*
		 * Delete a media
		 */
		int delMedia(int row);

		/*
		 * Return info on a file
		 */
		Media getInfos(unsigned int row);

		/*
		 * Return the index of the currently played media
		 */
		int getCurrentPlayedMedia()
		{
			return currentPlayedMedia;
		}

		/*
		 * Return the uri index 'row'
		 */
		QString getUri(unsigned int row);
		
		/*
		 * Clear every list : playlist, media list, uris list sources list
		 */
		void clearPlayList();

		/*
		 * Convert a time in milliseconds to a human readable string (3:40)
		 */
		static QString msToString(qint64 ms);
		
		void startMetaUpdater(bool reload=false);

		/*
		 * Return the state of the player (is it playing ? paused ?)
		 */
		Phonon::State getReadingState()
		{
			Phonon::State ret = Phonon::ErrorState;
			if (mediaObject)
			{
				ret = mediaObject->state();
			}
			return ret;
		}

		

	public slots:
		void metaInfosUpdated(Phonon::State state, Phonon::State oldState);
		void currentInfosUpdated(Phonon::State newState, Phonon::State oldState);
		void refreshPlayedTime();
		void playEnded();

	private:		
		int currentPlayedMedia;

		Phonon::SeekSlider* seekSlider;
		Phonon::AudioOutput* audioOutput;
		Phonon::MediaObject* mediaObject;	
		Phonon::MediaObject* mediaObjectForMetaInfos;
		Phonon::VolumeSlider *volumeSlider;

		QVBoxLayout* seekLayout;
		QHBoxLayout* timeLayout;
                QVBoxLayout* volLayout;

		QLabel *currentTime, *totalTime;

		QVector<Media> listMedias;
		QVector<Phonon::MediaSource> listSources;
		QVector<QString> listUris;
		Media tmpMedia;
		
		UPlay* parent;
		
		int lastUpdated;
};

#endif
